/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qianfan;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.Parameter;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.qianfan.QianFanLlmConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class QianFanLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildFunctionJsonArray(List<Map<String, Object>> functionsJsonArray, List<Function> functions) {
            for (Function function : functions) {
                HashMap<String, Object> functionRoot = new HashMap<String, Object>();
                functionRoot.put("type", "function");
                HashMap<String, Object> functionObj = new HashMap<String, Object>();
                functionRoot.put("function", functionObj);
                functionObj.put("name", function.getName());
                functionObj.put("description", function.getDescription());
                HashMap<String, Object> parametersObj = new HashMap<String, Object>();
                functionObj.put("parameters", parametersObj);
                parametersObj.put("type", "object");
                HashMap propertiesObj = new HashMap();
                parametersObj.put("properties", propertiesObj);
                ArrayList<String> requiredProperties = new ArrayList<String>();
                for (Parameter parameter : function.getParameters()) {
                    HashMap<String, Object> parameterObj = new HashMap<String, Object>();
                    parameterObj.put("type", parameter.getType());
                    parameterObj.put("description", parameter.getDescription());
                    if (parameter.getEnums().length > 0) {
                        parameterObj.put("enum", parameter.getEnums());
                    }
                    if (parameter.isRequired()) {
                        requiredProperties.add(parameter.getName());
                    }
                    propertiesObj.put(parameter.getName(), parameterObj);
                }
                if (!requiredProperties.isEmpty()) {
                    parametersObj.put("required", requiredProperties);
                }
                functionsJsonArray.add(functionRoot);
            }
        }
    };

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        return DefaultAiMessageParser.getChatGPTMessageParser((boolean)isStream);
    }

    public static String promptToEmbeddingsPayload(Document text, EmbeddingOptions options, QianFanLlmConfig config) {
        ArrayList<String> documents = new ArrayList<String>();
        documents.add(text.getContent());
        return Maps.of((String)"model", (Object)options.getModelOrDefault(config.getEmbeddingModel())).set("encoding_format", (Object)"float").set("input", documents).toJSON();
    }

    public static String promptToPayload(Prompt prompt, QianFanLlmConfig config, ChatOptions options, boolean withStream) {
        List messages = prompt.toMessages();
        HumanMessage message = MessageUtil.findLastHumanMessage((List)messages);
        return Maps.of((String)"model", (Object)Optional.ofNullable(options.getModel()).orElse(config.getModel())).set("messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "stream", (Object)true).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("tools", "tool_choice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotEmpty("stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).toJSON();
    }
}

