/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.gitee;

import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.gitee.GiteeAiLlmConfig;
import java.util.List;

public class GiteeAiLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        return DefaultAiMessageParser.getChatGPTMessageParser((boolean)isStream);
    }

    public static String promptToPayload(Prompt prompt, GiteeAiLlmConfig config, ChatOptions options, boolean withStream) {
        List messages = prompt.toMessages();
        HumanMessage message = MessageUtil.findLastHumanMessage((List)messages);
        return Maps.of().set("messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "stream", (Object)withStream).setIfNotNull("max_tokens", (Object)options.getMaxTokens()).setIfNotNull("temperature", (Object)options.getTemperature()).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("tools", "tool_choice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotNull("top_k", (Object)options.getTopK()).setIfNotEmpty("stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).toJSON();
    }
}

