/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.llm.response.FunctionCaller;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.ToolMessage;
import com.agentsflex.core.prompt.HistoriesPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;

public class ToolPrompt
extends Prompt {
    protected List<Message> messages;

    public static ToolPrompt of(AiMessageResponse response) {
        return ToolPrompt.of(response, null);
    }

    public static ToolPrompt of(AiMessageResponse response, HistoriesPrompt withHistories) {
        List<FunctionCaller> functionCallers = response.getFunctionCallers();
        ArrayList<Message> toolMessages = new ArrayList<Message>(functionCallers.size());
        for (FunctionCaller functionCaller : functionCallers) {
            ToolMessage toolMessage = new ToolMessage();
            String callId = functionCaller.getFunctionCall().getId();
            if (StringUtil.hasText(callId)) {
                toolMessage.setToolCallId(callId);
            } else {
                toolMessage.setToolCallId(functionCaller.getFunctionCall().getName());
            }
            Object object = functionCaller.call();
            if (object instanceof CharSequence || object instanceof Number) {
                toolMessage.setContent(object.toString());
            } else {
                toolMessage.setContent(JSON.toJSONString((Object)object));
            }
            toolMessages.add(toolMessage);
        }
        if (withHistories != null) {
            withHistories.addMessages(response.getPrompt().toMessages());
            withHistories.addMessage(response.getMessage());
            withHistories.addMessages(toolMessages);
            return new HistoriesToolPrompt(withHistories);
        }
        ToolPrompt toolPrompt = new ToolPrompt();
        toolPrompt.messages = new ArrayList<Message>();
        toolPrompt.messages.addAll(response.getPrompt().toMessages());
        toolPrompt.messages.add(response.getMessage());
        toolPrompt.messages.addAll(toolMessages);
        return toolPrompt;
    }

    @Override
    public List<Message> toMessages() {
        return this.messages;
    }

    public String toString() {
        return "ToolPrompt{messages=" + this.messages + ", metadataMap=" + this.metadataMap + '}';
    }

    static class HistoriesToolPrompt
    extends ToolPrompt {
        HistoriesPrompt historiesPrompt;

        public HistoriesToolPrompt(HistoriesPrompt historiesPrompt) {
            this.historiesPrompt = historiesPrompt;
        }

        @Override
        public List<Message> toMessages() {
            return this.historiesPrompt.toMessages();
        }

        @Override
        public String toString() {
            return "HistoriesToolPrompt{historiesPrompt=" + this.historiesPrompt + ", messages=" + this.messages + ", metadataMap=" + this.metadataMap + '}';
        }
    }
}

