/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.impl;

import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.impl.SequentialChain;
import com.agentsflex.core.chain.node.StartNode;

public class LoopChain
extends SequentialChain {
    private int maxLoopCount = Integer.MAX_VALUE;
    private int executeCount = 0;

    public LoopChain() {
        this.addNode(new StartNode());
    }

    public int getMaxLoopCount() {
        return this.maxLoopCount;
    }

    public void setMaxLoopCount(int maxLoopCount) {
        this.maxLoopCount = maxLoopCount;
    }

    public void close() {
        if (this.nodes.size() < 2) {
            return;
        }
        String sourceId = ((ChainNode)this.nodes.get(this.nodes.size() - 1)).getId();
        String targetId = ((ChainNode)this.nodes.get(1)).getId();
        ChainEdge edge = new ChainEdge();
        edge.setSource(sourceId);
        edge.setTarget(targetId);
        super.addEdge(edge);
    }

    @Override
    protected void onNodeExecuteAfter(NodeContext nodeContext) {
        if (this.executeCount++ >= this.maxLoopCount) {
            this.stopNormal("Loop to the maxLoopCount limit");
        }
    }
}

