/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.db.sql.SqlFormatter;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.log.level.Level;

public enum SqlLog {
    INSTASNCE;

    private static final Log log;
    private boolean showSql;
    private boolean formatSql;
    private boolean showParams;
    private Level level = Level.DEBUG;

    public void init(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        this.showSql = isShowSql;
        this.formatSql = isFormatSql;
        this.showParams = isShowParams;
        this.level = level;
    }

    public void log(String sql, Object paramValues) {
        if (this.showSql) {
            if (this.showParams) {
                log.log(this.level, "\nSQL -> {}\nParams -> {}", new Object[]{this.formatSql ? SqlFormatter.format(sql) : sql, paramValues});
            } else {
                log.log(this.level, "\nSQL -> {}", new Object[]{this.formatSql ? SqlFormatter.format(sql) : sql});
            }
        }
    }

    static {
        log = LogFactory.get();
    }
}

