/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.db.sql.Order;
import java.io.Serializable;
import java.util.Arrays;

public class Page
implements Serializable {
    private static final long serialVersionUID = 97792549823353462L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageNumber;
    private int pageSize;
    private Order[] orders;

    public Page() {
        this(0, 20);
    }

    public Page(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Page(int pageNumber, int numPerPage, Order order) {
        this(pageNumber, numPerPage);
        this.orders = new Order[]{order};
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
    }

    @Deprecated
    public int getNumPerPage() {
        return this.getPageSize();
    }

    @Deprecated
    public void setNumPerPage(int pageSize) {
        this.setPageSize(pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrder(Order ... orders) {
        this.orders = orders;
    }

    public void addOrder(Order ... orders) {
        if (null != this.orders) {
            ArrayUtil.append((Object[])this.orders, (Object[])orders);
        }
        this.orders = orders;
    }

    public int getStartPosition() {
        return this.getStartEnd()[0];
    }

    public int getEndPosition() {
        return this.getStartEnd()[1];
    }

    public int[] getStartEnd() {
        return PageUtil.transToStartEnd((int)this.pageNumber, (int)this.pageSize);
    }

    public String toString() {
        return "Page [page=" + this.pageNumber + ", pageSize=" + this.pageSize + ", order=" + Arrays.toString(this.orders) + "]";
    }
}

