/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.StrUtil;

public class NumberChineseFormatter {
    private static final String[] SIMPLE_DIGITS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] TRADITIONAL_DIGITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] SIMPLE_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] TRADITIONAL_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChineseFormatter.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        String[] numArray;
        String[] stringArray = numArray = isUseTraditional ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        StringBuilder chineseStr = new StringBuilder();
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumberChineseFormatter.toChinese(parts[i2], isUseTraditional);
            if (i2 % 2 == 0) {
                beforeWanIsZero = StrUtil.isEmpty(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr.insert(0, "\u4ebf");
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr.insert(0, "\u96f6");
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr.insert(0, "\u96f6");
                    }
                    if (parts[i2] > 0) {
                        chineseStr.insert(0, "\u4e07");
                    }
                }
            }
            chineseStr.insert(0, partChinese);
        }
        if ("".equals(chineseStr.toString())) {
            chineseStr = new StringBuilder(numArray[0]);
        }
        if (negative) {
            chineseStr.insert(0, "\u8d1f");
        }
        if (numFen != 0 || numJiao != 0) {
            if (numFen == 0) {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(numArray[numJiao]).append(isMoneyMode ? "\u89d2" : "");
            } else if (numJiao == 0) {
                chineseStr.append(isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6").append(numArray[numFen]).append(isMoneyMode ? "\u5206" : "");
            } else {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(numArray[numJiao]).append(isMoneyMode ? "\u89d2" : "").append(numArray[numFen]).append(isMoneyMode ? "\u5206" : "");
            }
        } else if (isMoneyMode) {
            chineseStr.append("\u5143\u6574");
        }
        return chineseStr.toString();
    }

    public static String numberCharToChinese(char c, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        int index = c - 48;
        if (index < 0 || index >= numArray.length) {
            return String.valueOf(c);
        }
        return numArray[index];
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        String[] numArray = isUseTraditional ? TRADITIONAL_DIGITS : SIMPLE_DIGITS;
        String[] units = isUseTraditional ? TRADITIONAL_UNITS : SIMPLE_UNITS;
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, numArray[digit] + units[i]);
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }
}

