/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.factory;

import cn.easyes.common.enums.ProcessIndexStrategyEnum;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.starter.config.EasyEsConfigProperties;
import cn.easyes.starter.service.AutoProcessIndexService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={RestHighLevelClient.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class IndexStrategyFactory
implements ApplicationContextAware,
InitializingBean {
    @Autowired
    private EasyEsConfigProperties esConfigProperties;
    private static final Integer DEFAULT_SIZE = 4;
    private ApplicationContext applicationContext;
    private static final Map<Integer, AutoProcessIndexService> SERVICE_MAP = new HashMap<Integer, AutoProcessIndexService>(DEFAULT_SIZE);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        if (!ProcessIndexStrategyEnum.MANUAL.equals((Object)this.esConfigProperties.getGlobalConfig().getProcessIndexMode())) {
            this.applicationContext.getBeansOfType(AutoProcessIndexService.class).values().forEach(v -> SERVICE_MAP.putIfAbsent(v.getStrategyType(), (AutoProcessIndexService)v));
        }
    }

    public AutoProcessIndexService getByStrategyType(Integer strategyType) {
        return Optional.ofNullable(SERVICE_MAP.get(strategyType)).orElseThrow(() -> ExceptionUtils.eee((String)"no such service strategyType:{}", (Object[])new Object[]{strategyType}));
    }
}

