/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.register;

import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.core.conditions.interfaces.BaseEsMapper;
import cn.easyes.starter.register.MapperFactoryBean;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;

public class ClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        this.addIncludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            try {
                boolean isEeMapper;
                Class<?> clazz = Class.forName(className);
                Object[] interfaces = clazz.getInterfaces();
                if (ArrayUtils.isNotEmpty((Object[])interfaces) && !(isEeMapper = Arrays.asList(interfaces).contains(BaseEsMapper.class))) {
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                this.logger.debug((Object)("mapper not found" + e));
            }
            return true;
        });
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return className.endsWith("package-info");
        });
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No Easy-Es mapper was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            this.logger.debug((Object)("Creating MapperFactoryBean with name '" + holder.getBeanName() + "' and '" + beanClassName + "' mapperInterface"));
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            definition.setBeanClass(MapperFactoryBean.class);
            this.logger.debug((Object)("Enabling autowire by type for MapperFactoryBean with name '" + holder.getBeanName() + "'."));
            definition.setAutowireMode(2);
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping MapperFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' mapperInterface. Bean already defined with the same name!"));
        return false;
    }
}

