/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.template;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoServerConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.model.SaSsoClientModel;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class SaSsoServerTemplate
extends SaSsoTemplate {
    public SaSsoServerConfig getServerConfig() {
        return SaSsoManager.getServerConfig();
    }

    public void saveTicket(String ticket, Object loginId) {
        long ticketTimeout = this.getServerConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketSaveKey(ticket), String.valueOf(loginId), ticketTimeout);
    }

    public void saveTicketIndex(String ticket, Object loginId) {
        long ticketTimeout = this.getServerConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketIndexKey(loginId), String.valueOf(ticket), ticketTimeout);
    }

    public void saveTicketToClient(String ticket, String client) {
        if (SaFoxUtil.isEmpty((Object)client)) {
            return;
        }
        long ticketTimeout = this.getServerConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketToClientSaveKey(ticket), client, ticketTimeout);
    }

    public void deleteTicket(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketSaveKey(ticket));
    }

    public void deleteTicketIndex(Object loginId) {
        if (loginId == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketIndexKey(loginId));
    }

    public void deleteTicketToClient(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketToClientSaveKey(ticket));
    }

    public Object getLoginId(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return (T)SaFoxUtil.getValueByType((Object)this.getLoginId(ticket), cs);
    }

    public String getTicketValue(Object loginId) {
        if (loginId == null) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketIndexKey(loginId));
    }

    public String getTicketToClient(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketToClientSaveKey(ticket));
    }

    public String createTicket(Object loginId, String client) {
        String ticket = this.randomTicket(loginId);
        this.saveTicket(ticket, loginId);
        this.saveTicketIndex(ticket, loginId);
        this.saveTicketToClient(ticket, client);
        return ticket;
    }

    public Object checkTicket(String ticket) {
        return this.checkTicket(ticket, "*");
    }

    public Object checkTicket(String ticket, String client) {
        String loginId = SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
        if (loginId != null) {
            String ticketClient = this.getTicketToClient(ticket);
            if (!("*".equals(client) || SaFoxUtil.isEmpty((Object)client) && SaFoxUtil.isEmpty((Object)ticketClient) || !SaFoxUtil.notEquals((Object)client, (Object)ticketClient))) {
                throw new SaSsoException("\u8be5 ticket \u4e0d\u5c5e\u4e8e client=" + client + ", ticket \u503c: " + ticket).setCode(30011);
            }
            this.deleteTicket(ticket);
            this.deleteTicketIndex(loginId);
            this.deleteTicketToClient(ticket);
        }
        return loginId;
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString((int)64);
    }

    public String getAllowUrl() {
        return this.getServerConfig().getAllowUrl();
    }

    public void checkRedirectUrl(String url) {
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaSsoException("\u65e0\u6548redirect\uff1a" + url).setCode(30001);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (url.contains("@")) {
            throw new SaSsoException("\u65e0\u6548redirect\uff08\u4e0d\u5141\u8bb8\u51fa\u73b0@\u5b57\u7b26\uff09\uff1a" + url).setCode(30001);
        }
        List<String> allowUrlList = Arrays.asList(this.getAllowUrl().replaceAll(" ", "").split(","));
        this.checkAllowUrlList(allowUrlList);
        if (!((Boolean)SaStrategy.instance.hasElement.apply(allowUrlList, (Object)url)).booleanValue()) {
            throw new SaSsoException("\u975e\u6cd5redirect\uff1a" + url).setCode(30002);
        }
    }

    public void checkAllowUrlList(List<String> allowUrlList) {
        SaSsoServerTemplate.checkAllowUrlListStaticMethod(allowUrlList);
    }

    public static void checkAllowUrlListStaticMethod(List<String> allowUrlList) {
        for (String url : allowUrlList) {
            int index = url.indexOf("*");
            if (index == -1 || index == url.length() - 1) continue;
            throw new SaSsoException("\u65e0\u6548\u7684 allow-url \u914d\u7f6e\uff08*\u901a\u914d\u7b26\u53ea\u5141\u8bb8\u51fa\u73b0\u5728\u6700\u540e\u4e00\u4f4d\uff09\uff1a" + url).setCode(30015);
        }
    }

    public void ssoLogout(Object loginId) {
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        List scmList = (List)session.get("SSO_CLIENT_MODEL_LIST_KEY_", ArrayList::new);
        scmList.forEach(scm -> this.notifyClientLogout(loginId, (SaSsoClientModel)scm, false));
        this.getStpLogic().logout(loginId);
    }

    public int calcNextIndex(List<SaSsoClientModel> scmList) {
        if (scmList == null || scmList.isEmpty()) {
            return 0;
        }
        int maxIndex = scmList.get((int)(scmList.size() - 1)).index;
        if (maxIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return ++maxIndex;
    }

    public void registerSloCallbackUrl(Object loginId, String client, String sloCallbackUrl) {
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            return;
        }
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId);
        List scmList = (List)session.get("SSO_CLIENT_MODEL_LIST_KEY_", ArrayList::new);
        SaSsoClientModel scm = new SaSsoClientModel(client, sloCallbackUrl, this.calcNextIndex(scmList));
        scmList.add(scm);
        int maxRegClient = this.getServerConfig().maxRegClient;
        if (maxRegClient != -1) {
            while (scmList.size() > maxRegClient) {
                SaSsoClientModel removeScm = (SaSsoClientModel)scmList.remove(0);
                this.notifyClientLogout(loginId, removeScm, true);
            }
        }
        session.set("SSO_CLIENT_MODEL_LIST_KEY_", (Object)scmList);
    }

    public void notifyClientLogout(Object loginId, SaSsoClientModel scm, boolean autoLogout) {
        if (scm == null || scm.mode != 3) {
            return;
        }
        String sloCallUrl = scm.getSloCallbackUrl();
        if (SaFoxUtil.isEmpty((Object)sloCallUrl)) {
            return;
        }
        TreeMap<String, Object> paramsMap = new TreeMap<String, Object>();
        paramsMap.put(this.paramName.client, scm.getClient());
        paramsMap.put(this.paramName.loginId, loginId);
        paramsMap.put(this.paramName.autoLogout, autoLogout);
        String signParamsStr = this.getSignTemplate(scm.getClient()).addSignParamsAndJoin(paramsMap);
        String finalUrl = SaFoxUtil.joinParam((String)sloCallUrl, (String)signParamsStr);
        this.getServerConfig().sendHttp.apply(finalUrl);
    }

    public String buildRedirectUrl(Object loginId, String client, String redirect) {
        this.checkRedirectUrl(redirect);
        this.deleteTicket(this.getTicketValue(loginId));
        String ticket = this.createTicket(loginId, client);
        return SaFoxUtil.joinParam((String)this.encodeBackParam(redirect), (String)this.paramName.ticket, (Object)ticket);
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + this.paramName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + this.paramName.back + "=")) == -1) {
            return url;
        }
        int length = this.paramName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl((String)back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public String splicingTicketSaveKey(String ticket) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingTicketToClientSaveKey(String ticket) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":ticket-client:" + ticket;
    }

    public String splicingTicketIndexKey(Object id) {
        return this.getStpLogic().getConfigOrGlobal().getTokenName() + ":id-ticket:" + id;
    }
}

