/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.template;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Map;
import java.util.TreeMap;

public class SaSsoClientTemplate
extends SaSsoTemplate {
    public SaSsoClientConfig getClientConfig() {
        return SaSsoManager.getClientConfig();
    }

    public Object getData(Map<String, Object> paramMap) {
        String getDataUrl = this.getClientConfig().splicingGetDataUrl();
        return this.getData(getDataUrl, paramMap);
    }

    public Object getData(String path, Map<String, Object> paramMap) {
        String url = this.buildCustomPathUrl(path, paramMap);
        return this.getClientConfig().sendHttp.apply(url);
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String serverUrl = ssoConfig.splicingAuthUrl();
        String client = ssoConfig.getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            serverUrl = SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.client, (Object)client);
        }
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        if (!clientLoginUrl.contains(this.paramName.back + "=" + back)) {
            clientLoginUrl = SaFoxUtil.joinParam((String)clientLoginUrl, (String)this.paramName.back, (Object)back);
        }
        return SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.redirect, (Object)clientLoginUrl);
    }

    public String buildCheckTicketUrl(String ticket, String ssoLogoutCallUrl) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String url = ssoConfig.splicingCheckTicketUrl();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put(this.paramName.ticket, ticket);
        paramMap.put(this.paramName.client, ssoConfig.getClient());
        paramMap.put(this.paramName.ssoLogoutCall, ssoLogoutCallUrl);
        String signParamStr = this.getSignTemplate(ssoConfig.getClient()).addSignParamsAndJoin(paramMap);
        return SaFoxUtil.joinParam((String)url, (String)signParamStr);
    }

    public String buildSloUrl(Object loginId) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String url = ssoConfig.splicingSloUrl();
        String currClient = ssoConfig.getClient();
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put(this.paramName.loginId, loginId);
        paramMap.put(this.paramName.client, currClient);
        String signParamsStr = this.getSignTemplate(currClient).addSignParamsAndJoin(paramMap);
        return SaFoxUtil.joinParam((String)url, (String)signParamsStr);
    }

    public String buildGetDataUrl(Map<String, Object> paramMap) {
        String getDataUrl = this.getClientConfig().getGetDataUrl();
        return this.buildCustomPathUrl(getDataUrl, paramMap);
    }

    public String buildCustomPathUrl(String path, Map<String, Object> paramMap) {
        SaSsoClientConfig ssoConfig = this.getClientConfig();
        String url = path;
        if (!url.startsWith("http")) {
            String serverUrl = ssoConfig.getServerUrl();
            SaSsoException.notEmpty(serverUrl, "\u8bf7\u5148\u914d\u7f6e sa-token.sso.server-url \u5730\u5740", 30012);
            url = SaFoxUtil.spliceTwoUrl((String)serverUrl, (String)path);
        }
        paramMap.put(this.paramName.client, ssoConfig.getClient());
        String signParamsStr = this.getSignTemplate(ssoConfig.getClient()).addSignParamsAndJoin(paramMap);
        return SaFoxUtil.joinParam((String)url, (String)signParamsStr);
    }

    public SaResult request(String url) {
        String body = (String)this.getClientConfig().sendHttp.apply(url);
        Map map = SaManager.getSaJsonTemplate().parseJsonToMap(body);
        return new SaResult(map);
    }
}

