/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.config;

import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.function.CheckTicketAppendDataFunction;
import cn.dev33.satoken.sso.function.DoLoginHandleFunction;
import cn.dev33.satoken.sso.function.NotLoginViewFunction;
import cn.dev33.satoken.sso.function.SendHttpFunction;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.io.Serializable;
import java.util.List;

public class SaSsoServerConfig
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String mode = "";
    public long ticketTimeout = 300L;
    public String allowUrl = "*";
    public String homeRoute;
    public Boolean isSlo = true;
    public Boolean isHttp = false;
    public Boolean autoRenewTimeout = false;
    public int maxRegClient = 32;
    public Boolean isCheckSign = true;
    public NotLoginViewFunction notLoginView = () -> "\u5f53\u524d\u4f1a\u8bdd\u5728SSO-Server\u8ba4\u8bc1\u4e2d\u5fc3\u5c1a\u672a\u767b\u5f55\uff08\u5f53\u524d\u672a\u914d\u7f6e\u767b\u5f55\u89c6\u56fe\uff09";
    public DoLoginHandleFunction doLoginHandle = (name, pwd) -> SaResult.error();
    public CheckTicketAppendDataFunction checkTicketAppendData = (loginId, result) -> result;
    public SendHttpFunction sendHttp = url -> {
        throw new SaSsoException("\u8bf7\u914d\u7f6e Http \u8bf7\u6c42\u5904\u7406\u5668").setCode(30010);
    };

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public long getTicketTimeout() {
        return this.ticketTimeout;
    }

    public SaSsoServerConfig setTicketTimeout(long ticketTimeout) {
        this.ticketTimeout = ticketTimeout;
        return this;
    }

    public String getAllowUrl() {
        return this.allowUrl;
    }

    public SaSsoServerConfig setAllowUrl(String allowUrl) {
        if (SaFoxUtil.isNotEmpty((Object)allowUrl)) {
            List allowUrlList = SaFoxUtil.convertStringToList((String)allowUrl);
            SaSsoServerTemplate.checkAllowUrlListStaticMethod(allowUrlList);
        }
        this.allowUrl = allowUrl;
        return this;
    }

    public String getHomeRoute() {
        return this.homeRoute;
    }

    public SaSsoServerConfig setHomeRoute(String homeRoute) {
        this.homeRoute = homeRoute;
        return this;
    }

    public Boolean getIsSlo() {
        return this.isSlo;
    }

    public SaSsoServerConfig setIsSlo(Boolean isSlo) {
        this.isSlo = isSlo;
        return this;
    }

    public Boolean getIsHttp() {
        return this.isHttp;
    }

    public SaSsoServerConfig setIsHttp(Boolean isHttp) {
        this.isHttp = isHttp;
        return this;
    }

    public Boolean getAutoRenewTimeout() {
        return this.autoRenewTimeout;
    }

    public SaSsoServerConfig setAutoRenewTimeout(Boolean autoRenewTimeout) {
        this.autoRenewTimeout = autoRenewTimeout;
        return this;
    }

    public int getMaxRegClient() {
        return this.maxRegClient;
    }

    public SaSsoServerConfig setMaxRegClient(int maxRegClient) {
        this.maxRegClient = maxRegClient;
        return this;
    }

    public Boolean getIsCheckSign() {
        return this.isCheckSign;
    }

    public SaSsoServerConfig setIsCheckSign(Boolean isCheckSign) {
        this.isCheckSign = isCheckSign;
        return this;
    }

    public SaSsoServerConfig setAllow(String ... url) {
        this.setAllowUrl(SaFoxUtil.arrayJoin((String[])url));
        return this;
    }

    public String toString() {
        return "SaSsoServerConfig [mode=" + this.mode + ", ticketTimeout=" + this.ticketTimeout + ", allowUrl=" + this.allowUrl + ", homeRoute=" + this.homeRoute + ", isSlo=" + this.isSlo + ", isHttp=" + this.isHttp + ", autoRenewTimeout=" + this.autoRenewTimeout + ", maxRegClient=" + this.maxRegClient + ", isCheckSign=" + this.isCheckSign + "]";
    }
}

