/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUCopyWithDynamicShape", inputsClass=Inputs.class)
public final class TPUCopyWithDynamicShape
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "TPUCopyWithDynamicShape";
    private List<Output<?>> tpuTensors;

    public TPUCopyWithDynamicShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int tpuTensorsLength = operation.outputListLength("tpu_tensors");
        this.tpuTensors = Arrays.asList(operation.outputList(outputIdx, tpuTensorsLength));
        outputIdx += tpuTensorsLength;
    }

    public static TPUCopyWithDynamicShape create(Scope scope, Iterable<Operand<?>> tensors, Iterable<Operand<TInt32>> unpaddedSizes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(tensors));
        opBuilder.addInputList(Operands.asOutputs(unpaddedSizes));
        return new TPUCopyWithDynamicShape(opBuilder.build());
    }

    public List<Output<?>> tpuTensors() {
        return this.tpuTensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.tpuTensors.iterator();
    }

    @OpInputsMetadata(outputsClass=TPUCopyWithDynamicShape.class)
    public static class Inputs
    extends RawOpInputs<TPUCopyWithDynamicShape> {
        public final Iterable<Operand<?>> tensors;
        public final Iterable<Operand<TInt32>> unpaddedSizes;
        public final DataType[] T;

        public Inputs(GraphOperation op) {
            super(new TPUCopyWithDynamicShape(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            int tensorsLength = op.inputListLength("tensors");
            this.tensors = Arrays.asList((Operand[])op.inputList(inputIndex, tensorsLength));
            int unpaddedSizesLength = op.inputListLength("unpadded_sizes");
            this.unpaddedSizes = Arrays.asList((Operand[])op.inputList(inputIndex += tensorsLength, unpaddedSizesLength));
            inputIndex += unpaddedSizesLength;
            this.T = op.attributes().getAttrTypeList("T");
        }
    }
}

