/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="GetMinibatchesInCsrWithPhysicalReplica", inputsClass=Inputs.class)
public final class GetMinibatchesInCsrWithPhysicalReplica
extends RawOp {
    public static final String OP_NAME = "GetMinibatchesInCsrWithPhysicalReplica";
    private Output<TInt32> rowPointers;
    private Output<TInt32> sortedSampleIds;
    private Output<TInt32> sortedTokenIds;
    private Output<TFloat32> sortedGains;
    private Output<TInt32> rowPointersUnpaddedSize;
    private Output<TInt32> idsUnpaddedSize;
    private Output<TInt32> numMinibatchesPerPhysicalSparseCore;

    public GetMinibatchesInCsrWithPhysicalReplica(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rowPointers = operation.output(outputIdx++);
        this.sortedSampleIds = operation.output(outputIdx++);
        this.sortedTokenIds = operation.output(outputIdx++);
        this.sortedGains = operation.output(outputIdx++);
        this.rowPointersUnpaddedSize = operation.output(outputIdx++);
        this.idsUnpaddedSize = operation.output(outputIdx++);
        this.numMinibatchesPerPhysicalSparseCore = operation.output(outputIdx++);
    }

    public static GetMinibatchesInCsrWithPhysicalReplica create(Scope scope, Operand<TString> programKey, Operand<TInt32> rowIds, Operand<TInt32> colIds, Operand<TFloat32> gains, Operand<TInt64> splits, Operand<TInt32> idCounts, Long sampleCount, Long numReplica, Long maxMinibatchesPerSc, Long maxIdsPerChipPerSample, Long tableVocabSize, Long featureWidth, Long numScPerChip, String tableName, String miniBatchInCsr) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(programKey.asOutput());
        opBuilder.addInput(rowIds.asOutput());
        opBuilder.addInput(colIds.asOutput());
        opBuilder.addInput(gains.asOutput());
        opBuilder.addInput(splits.asOutput());
        opBuilder.addInput(idCounts.asOutput());
        opBuilder.setAttr("sample_count", sampleCount);
        opBuilder.setAttr("num_replica", numReplica);
        opBuilder.setAttr("max_minibatches_per_sc", maxMinibatchesPerSc);
        opBuilder.setAttr("max_ids_per_chip_per_sample", maxIdsPerChipPerSample);
        opBuilder.setAttr("table_vocab_size", tableVocabSize);
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("num_sc_per_chip", numScPerChip);
        opBuilder.setAttr("table_name", tableName);
        opBuilder.setAttr("mini_batch_in_csr", miniBatchInCsr);
        return new GetMinibatchesInCsrWithPhysicalReplica(opBuilder.build());
    }

    public Output<TInt32> rowPointers() {
        return this.rowPointers;
    }

    public Output<TInt32> sortedSampleIds() {
        return this.sortedSampleIds;
    }

    public Output<TInt32> sortedTokenIds() {
        return this.sortedTokenIds;
    }

    public Output<TFloat32> sortedGains() {
        return this.sortedGains;
    }

    public Output<TInt32> rowPointersUnpaddedSize() {
        return this.rowPointersUnpaddedSize;
    }

    public Output<TInt32> idsUnpaddedSize() {
        return this.idsUnpaddedSize;
    }

    public Output<TInt32> numMinibatchesPerPhysicalSparseCore() {
        return this.numMinibatchesPerPhysicalSparseCore;
    }

    @OpInputsMetadata(outputsClass=GetMinibatchesInCsrWithPhysicalReplica.class)
    public static class Inputs
    extends RawOpInputs<GetMinibatchesInCsrWithPhysicalReplica> {
        public final Operand<TString> programKey;
        public final Operand<TInt32> rowIds;
        public final Operand<TInt32> colIds;
        public final Operand<TFloat32> gains;
        public final Operand<TInt64> splits;
        public final Operand<TInt32> idCounts;
        public final long sampleCount;
        public final long numReplica;
        public final long maxMinibatchesPerSc;
        public final long maxIdsPerChipPerSample;
        public final long tableVocabSize;
        public final long featureWidth;
        public final long numScPerChip;
        public final String tableName;
        public final String miniBatchInCsr;

        public Inputs(GraphOperation op) {
            super(new GetMinibatchesInCsrWithPhysicalReplica(op), op, Arrays.asList("sample_count", "num_replica", "max_minibatches_per_sc", "max_ids_per_chip_per_sample", "table_vocab_size", "feature_width", "num_sc_per_chip", "table_name", "mini_batch_in_csr"));
            int inputIndex = 0;
            this.programKey = op.input(inputIndex++);
            this.rowIds = op.input(inputIndex++);
            this.colIds = op.input(inputIndex++);
            this.gains = op.input(inputIndex++);
            this.splits = op.input(inputIndex++);
            this.idCounts = op.input(inputIndex++);
            this.sampleCount = op.attributes().getAttrInt("sample_count");
            this.numReplica = op.attributes().getAttrInt("num_replica");
            this.maxMinibatchesPerSc = op.attributes().getAttrInt("max_minibatches_per_sc");
            this.maxIdsPerChipPerSample = op.attributes().getAttrInt("max_ids_per_chip_per_sample");
            this.tableVocabSize = op.attributes().getAttrInt("table_vocab_size");
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.numScPerChip = op.attributes().getAttrInt("num_sc_per_chip");
            this.tableName = op.attributes().getAttrString("table_name");
            this.miniBatchInCsr = op.attributes().getAttrString("mini_batch_in_csr");
        }
    }
}

