/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParseSingleExample", inputsClass=Inputs.class)
public final class ParseSingleExample
extends RawOp {
    public static final String OP_NAME = "ParseSingleExample";
    private List<Output<TInt64>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<TInt64>> sparseShapes;
    private List<Output<?>> denseValues;

    public ParseSingleExample(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int sparseIndicesLength = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(outputIdx, sparseIndicesLength));
        int sparseValuesLength = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(outputIdx += sparseIndicesLength, sparseValuesLength));
        int sparseShapesLength = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(outputIdx += sparseValuesLength, sparseShapesLength));
        int denseValuesLength = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(outputIdx += sparseShapesLength, denseValuesLength));
        outputIdx += denseValuesLength;
    }

    public static ParseSingleExample create(Scope scope, Operand<TString> serialized, Iterable<Operand<?>> denseDefaults, Long numSparse, List<String> sparseKeys, List<String> denseKeys, List<Class<? extends TType>> sparseTypes, List<Shape> denseShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder.setAttr("num_sparse", numSparse);
        String[] sparseKeysArray = new String[sparseKeys.size()];
        for (int i = 0; i < sparseKeysArray.length; ++i) {
            sparseKeysArray[i] = sparseKeys.get(i);
        }
        opBuilder.setAttr("sparse_keys", sparseKeysArray);
        String[] denseKeysArray = new String[denseKeys.size()];
        for (int i = 0; i < denseKeysArray.length; ++i) {
            denseKeysArray[i] = denseKeys.get(i);
        }
        opBuilder.setAttr("dense_keys", denseKeysArray);
        opBuilder.setAttr("sparse_types", Operands.toDataTypes(sparseTypes));
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        return new ParseSingleExample(opBuilder.build());
    }

    public List<Output<TInt64>> sparseIndices() {
        return this.sparseIndices;
    }

    public List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public List<Output<TInt64>> sparseShapes() {
        return this.sparseShapes;
    }

    public List<Output<?>> denseValues() {
        return this.denseValues;
    }

    @OpInputsMetadata(outputsClass=ParseSingleExample.class)
    public static class Inputs
    extends RawOpInputs<ParseSingleExample> {
        public final Operand<TString> serialized;
        public final Iterable<Operand<?>> denseDefaults;
        public final String[] sparseKeys;
        public final String[] denseKeys;
        public final DataType[] sparseTypes;
        public final DataType[] Tdense;
        public final Shape[] denseShapes;

        public Inputs(GraphOperation op) {
            super(new ParseSingleExample(op), op, Arrays.asList("sparse_keys", "dense_keys", "sparse_types", "Tdense", "dense_shapes"));
            int inputIndex = 0;
            this.serialized = op.input(inputIndex++);
            int denseDefaultsLength = op.inputListLength("dense_defaults");
            this.denseDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, denseDefaultsLength));
            inputIndex += denseDefaultsLength;
            this.sparseKeys = op.attributes().getAttrStringList("sparse_keys");
            this.denseKeys = op.attributes().getAttrStringList("dense_keys");
            this.sparseTypes = op.attributes().getAttrTypeList("sparse_types");
            this.Tdense = op.attributes().getAttrTypeList("Tdense");
            this.denseShapes = op.attributes().getAttrShapeList("dense_shapes");
        }
    }
}

