/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalGroupByReducerDataset", inputsClass=Inputs.class)
public final class GroupByReducerDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalGroupByReducerDataset";
    private Output<? extends TType> handle;

    public GroupByReducerDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static GroupByReducerDataset create(Scope scope, Operand<? extends TType> inputDataset, Iterable<Operand<?>> keyFuncOtherArguments, Iterable<Operand<?>> initFuncOtherArguments, Iterable<Operand<?>> reduceFuncOtherArguments, Iterable<Operand<?>> finalizeFuncOtherArguments, ConcreteFunction keyFunc, ConcreteFunction initFunc, ConcreteFunction reduceFunc, ConcreteFunction finalizeFunc, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "GroupByReducerDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(keyFuncOtherArguments));
        opBuilder.addInputList(Operands.asOutputs(initFuncOtherArguments));
        opBuilder.addInputList(Operands.asOutputs(reduceFuncOtherArguments));
        opBuilder.addInputList(Operands.asOutputs(finalizeFuncOtherArguments));
        opBuilder.setAttr("key_func", keyFunc);
        opBuilder.setAttr("init_func", initFunc);
        opBuilder.setAttr("reduce_func", reduceFunc);
        opBuilder.setAttr("finalize_func", finalizeFunc);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new GroupByReducerDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=GroupByReducerDataset.class)
    public static class Inputs
    extends RawOpInputs<GroupByReducerDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Iterable<Operand<?>> keyFuncOtherArguments;
        public final Iterable<Operand<?>> initFuncOtherArguments;
        public final Iterable<Operand<?>> reduceFuncOtherArguments;
        public final Iterable<Operand<?>> finalizeFuncOtherArguments;
        public final DataType[] TkeyFuncOtherArguments;
        public final DataType[] TinitFuncOtherArguments;
        public final DataType[] TreduceFuncOtherArguments;
        public final DataType[] TfinalizeFuncOtherArguments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new GroupByReducerDataset(op), op, Arrays.asList("Tkey_func_other_arguments", "Tinit_func_other_arguments", "Treduce_func_other_arguments", "Tfinalize_func_other_arguments", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            int keyFuncOtherArgumentsLength = op.inputListLength("key_func_other_arguments");
            this.keyFuncOtherArguments = Arrays.asList((Operand[])op.inputList(inputIndex, keyFuncOtherArgumentsLength));
            int initFuncOtherArgumentsLength = op.inputListLength("init_func_other_arguments");
            this.initFuncOtherArguments = Arrays.asList((Operand[])op.inputList(inputIndex += keyFuncOtherArgumentsLength, initFuncOtherArgumentsLength));
            int reduceFuncOtherArgumentsLength = op.inputListLength("reduce_func_other_arguments");
            this.reduceFuncOtherArguments = Arrays.asList((Operand[])op.inputList(inputIndex += initFuncOtherArgumentsLength, reduceFuncOtherArgumentsLength));
            int finalizeFuncOtherArgumentsLength = op.inputListLength("finalize_func_other_arguments");
            this.finalizeFuncOtherArguments = Arrays.asList((Operand[])op.inputList(inputIndex += reduceFuncOtherArgumentsLength, finalizeFuncOtherArgumentsLength));
            inputIndex += finalizeFuncOtherArgumentsLength;
            this.TkeyFuncOtherArguments = op.attributes().getAttrTypeList("Tkey_func_other_arguments");
            this.TinitFuncOtherArguments = op.attributes().getAttrTypeList("Tinit_func_other_arguments");
            this.TreduceFuncOtherArguments = op.attributes().getAttrTypeList("Treduce_func_other_arguments");
            this.TfinalizeFuncOtherArguments = op.attributes().getAttrTypeList("Tfinalize_func_other_arguments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

