/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayPack", inputsClass=Inputs.class)
public final class TensorArrayPack<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorArrayPack";
    private Output<T> value;

    public TensorArrayPack(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorArrayPack<T> create(Scope scope, Operand<TString> handle, Operand<TFloat32> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape == null) continue;
                opBuilder.setAttr("element_shape", opts.elementShape);
            }
        }
        return new TensorArrayPack<T>(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    @OpInputsMetadata(outputsClass=TensorArrayPack.class)
    public static class Inputs
    extends RawOpInputs<TensorArrayPack<?>> {
        public final Operand<TString> handle;
        public final Operand<TFloat32> flowIn;
        public final DataType dtype;
        public final Shape elementShape;

        public Inputs(GraphOperation op) {
            super(new TensorArrayPack(op), op, Arrays.asList("dtype", "element_shape"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.flowIn = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.elementShape = op.attributes().getAttrShape("element_shape");
        }
    }

    public static class Options {
        private Shape elementShape;

        private Options() {
        }

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }
    }
}

