/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="OptionalGetValue", inputsClass=Inputs.class)
public final class OptionalGetValue
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "OptionalGetValue";
    private List<Output<?>> components;

    public OptionalGetValue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static OptionalGetValue create(Scope scope, Operand<? extends TType> optional, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(optional.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new OptionalGetValue(opBuilder.build());
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    @OpInputsMetadata(outputsClass=OptionalGetValue.class)
    public static class Inputs
    extends RawOpInputs<OptionalGetValue> {
        public final Operand<? extends TType> optional;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new OptionalGetValue(op), op, Arrays.asList("output_types", "output_shapes"));
            int inputIndex = 0;
            this.optional = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

