/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class ByteSparseSlice
extends SparseSlice<Byte, ByteNdArray>
implements ByteNdArray {
    public ByteSparseSlice(AbstractSparseNdArray<Byte, ByteNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public ByteNdArray toDense() {
        ByteDataBuffer dataBuffer = DataBuffers.ofBytes(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public byte getByte(long ... coordinates) {
        return (Byte)this.getObject(coordinates);
    }

    @Override
    public ByteNdArray setByte(byte value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray setObject(Byte value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray set(NdArray<Byte> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray read(DataBuffer<Byte> dst) {
        Byte[] defaults = new Byte[(int)this.shape().size()];
        dst.write((Byte[])defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            byte value = ((ByteNdArray)this.getValues()).getByte(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public ByteNdArray read(ByteDataBuffer dst) {
        return this.read((DataBuffer)dst);
    }

    @Override
    public ByteNdArray write(DataBuffer<Byte> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray write(ByteDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public ByteNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new ByteSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public ByteNdArray get(long ... coordinates) {
        return (ByteNdArray)super.get(coordinates);
    }

    @Override
    public ByteNdArray copyTo(NdArray<Byte> dst) {
        return (ByteNdArray)super.copyTo(dst);
    }

    @Override
    public ByteNdArray createDefaultArray() {
        return (ByteNdArray)this.source.getDefaultArray();
    }
}

