/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.utils.CertificateBuilder;
import cn.com.syan.jcee.utils.MessageDigestUtil;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.x509.extension.X509ExtensionUtil;

public class CertificateUtil {
    public static String getMD5FingerPrint(String cert) throws CertificateException {
        X509Certificate certificate = CertificateBuilder.buildCertificate(cert);
        return CertificateUtil.getMD5FingerPrint(certificate);
    }

    public static String getSHA1FingerPrint(String cert) throws CertificateException {
        X509Certificate certificate = CertificateBuilder.buildCertificate(cert);
        return CertificateUtil.getSHA1FingerPrint(certificate);
    }

    public static String getMD5FingerPrint(X509Certificate certificate) throws CertificateException {
        return CertificateUtil.getFingerPrint(certificate, "MD5");
    }

    public static String getSHA1FingerPrint(X509Certificate certificate) throws CertificateException {
        return CertificateUtil.getFingerPrint(certificate, "SHA1");
    }

    private static String getFingerPrint(X509Certificate certificate, String hashAlgorithm) throws CertificateException {
        String fingerPrint = null;
        try {
            fingerPrint = MessageDigestUtil.digest((byte[])certificate.getEncoded(), (String)hashAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return fingerPrint;
    }

    public static String getSubjectItem(String item, String certificate) throws CertificateException {
        X509Certificate x509Certificate = CertificateBuilder.buildCertificate(certificate);
        String name = x509Certificate.getSubjectDN().getName();
        Collection collection = X509ExtensionUtil.getIssuerAlternativeNames((X509Certificate)x509Certificate);
        return name;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String v = "MIIESDCCA7GgAwIBAgINAKSNzbZT9xB6OL1VezANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJDTjEQMA4GA1UEBxMHSmlhbmdTdTESMBAGA1UEChMJU1lBTiBUZWNoMRAwDgYDVQQLEwdTdXBwb3J0MQ8wDQYDVQQDEwZURVNUQ0ExITAfBgNVBC0TGDEyOTE5NTgyMjVVNEQwMUI3RDE0NzlGQzAeFw0xNDAzMTcxNjAwMDBaFw0xOTAxMDQxNjAwMDBaMIGFMQswCQYDVQQGEwJDTjENMAsGA1UEKhMEVVNFUjEiMCAGBFUELRETGDg3NzMzRkZDRkNGQUQ4ODRFQTdBNDBGNzEOMAwGA1UEChMFU3BhcmsxDjAMBgNVBAsTBVNwYXJrMSMwIQYDVQQDHhoAUwBwAGEAcgBrACBtS4vVdShiNwAoTgAAKTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK394PCE77lRHdg3kGqqSEc8Txyo4+6ClhCA6kCmcLbK74LhElkXtYcGTyqBgv+fO6iCnHkchQYsjZFnDjuhMuHhQBXE3AT5AF49dmnvijW394waxx7N/muD2Yp8K3x2SsdAJYcC3rcdCz86vrktCzu6nxYUJpASfRGwrY7U0ZdPVLXk17aH2c/NP2J517Hi5GJOtr+V4d5DlDv3n6pVF3XFC96jd5UBDqs/jTBWb1TRv3dowqUOXi1BOic2uZPI9cueQMCc9r5oeJPDUHqa/8KWfGE5FpFMQxjg1MZDcsCn4hvxgQ2EvSwMJwkgttzKk1+EyUCNMUxoKVav9r3rUjUCAwEAAaOCAUEwggE9MAkGA1UdEwQCMAAwIQYJYIZIAYb4QgENBBQWEk5FVE9ORSBjZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUeYjF3MRgUDdqaFvbXF8nhABHukkwgasGA1UdIwSBozCBoIAUPimQCdnOOzanjSH8mkStJZ62TXWhfaR7MHkxCzAJBgNVBAYTAkNOMRAwDgYDVQQHEwdKaWFuZ1N1MRIwEAYDVQQKEwlTWUFOIFRlY2gxEDAOBgNVBAsTB1N1cHBvcnQxDzANBgNVBAMTBlRFU1RDQTEhMB8GA1UELRMYMTI5MTk1ODIyNVU0RDAxQjdEMTQ3OUZDggkAteCoPdNpfzMwCwYDVR0PBAQDAgTwMDMGA1UdJQQsMCoGCCsGAQUFBwMCBggrBgEFBQcDBAYIKwYBBQUHAwgGCisGAQQBgjcKAwQwDQYJKoZIhvcNAQEFBQADgYEAZQTlKDK03hCLt6gR5Hb+HLgjUHQR+LN8V7eVdGH3u4ZnOutyg5KYJ8HtJl8JJQwXQA+HP7ILtamDNFueAEbxXB9xogo1kEMPtuzG6KfBAcP6QSoxxLwICBLzJM2yhRVvXTrcCMB6QVD2Sb8+PWapqQLOuhpx184DbrCRYUfHFn0=";
        String fp = CertificateUtil.getSubjectItem(",", v);
        System.out.print(fp);
    }
}

