/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERBMPString;
import org.spongycastle.asn1.DERIA5String;
import org.spongycastle.asn1.DERNumericString;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERT61String;
import org.spongycastle.asn1.DERUTF8String;
import org.spongycastle.asn1.x500.AttributeTypeAndValue;
import org.spongycastle.asn1.x500.RDN;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.Certificate;
import org.spongycastle.util.encoders.Base64;

public class CertificateStandardizedUtil {
    public static String[] getItemFromSubjectDN(String item, X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getItemFromDN(item, CertificateStandardizedUtil.getSubject(cert));
    }

    public static String[] getItemFromIssuerDN(String item, X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getItemFromDN(item, CertificateStandardizedUtil.getIssuer(cert));
    }

    public static String[] getItemFromDN(String item, String dn) {
        String sym = "__@@##@@__";
        String icn = "\\,";
        String tempDN = dn.replace(icn, sym);
        String[] kvPairs = tempDN.split(",");
        ArrayList<String> values = new ArrayList<String>();
        for (String kv : kvPairs) {
            if (kv.indexOf(item + "=") != 0) continue;
            String value = kv.substring(item.length() + 1);
            values.add(value.replace(sym, icn));
        }
        if (values.size() == 0) {
            return null;
        }
        kvPairs = new String[values.size()];
        return values.toArray(kvPairs);
    }

    public static String getSubject(X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(cert, true);
    }

    public static String getSubject(String certValue) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(Base64.decode((String)certValue), true);
    }

    public static String getSubject(byte[] certValue) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(certValue, true);
    }

    public static X500Name getSubjectX500Name(X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(cert, true);
    }

    public static X500Name getSubjectX500Name(String cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(Base64.decode((String)cert), true);
    }

    public static X500Name getSubjectX500Name(byte[] cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(cert, true);
    }

    public static String getIssuer(X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(cert, false);
    }

    public static String getIssuer(String cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(Base64.decode((String)cert), false);
    }

    public static String getIssuer(byte[] cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(cert, false);
    }

    public static X500Name getIssuerX500Name(X509Certificate cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(cert, false);
    }

    public static X500Name getIssuerX500Name(String cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(Base64.decode((String)cert), false);
    }

    public static X500Name getIssuerX500Name(byte[] cert) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuerX500Name(cert, false);
    }

    private static X500Name getSubjectOrIssuerX500Name(byte[] cert, boolean subject) throws CertificateEncodingException {
        Certificate certificate = Certificate.getInstance((Object)cert);
        if (certificate == null) {
            return null;
        }
        return subject ? certificate.getSubject() : certificate.getIssuer();
    }

    private static X500Name getSubjectOrIssuerX500Name(X509Certificate cert, boolean subject) throws CertificateEncodingException {
        Certificate certificate = Certificate.getInstance((Object)cert.getEncoded());
        if (certificate == null) {
            return null;
        }
        return subject ? certificate.getSubject() : certificate.getIssuer();
    }

    private static String getSubjectOrIssuer(X509Certificate cert, boolean subject) throws CertificateEncodingException {
        return CertificateStandardizedUtil.getSubjectOrIssuer(cert.getEncoded(), subject);
    }

    private static String getSubjectOrIssuer(byte[] cert, boolean subject) throws CertificateEncodingException {
        Certificate certificate = Certificate.getInstance((Object)cert);
        if (certificate == null) {
            return null;
        }
        X500Name x500Name = subject ? certificate.getSubject() : certificate.getIssuer();
        x500Name = new X500Name(CertificateStandardizedUtil.transfer2DERUTF8String(x500Name.getRDNs()));
        return x500Name.toString();
    }

    public static X500Name transfer2DERUTF8X500Name(X500Name x500Name) {
        return new X500Name(CertificateStandardizedUtil.transfer2DERUTF8String(x500Name.getRDNs()));
    }

    private static RDN transfer2UTF8RDN(ASN1ObjectIdentifier type, byte[] binary) throws UnsupportedEncodingException {
        DERUTF8String utf8Value = new DERUTF8String(new String(binary, "UTF-8"));
        AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(type, (ASN1Encodable)utf8Value);
        return new RDN(attributeTypeAndValue);
    }

    private static RDN transfer2UTF8RDN(ASN1ObjectIdentifier type, ASN1Encodable utf8Value) throws UnsupportedEncodingException {
        AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(type, utf8Value);
        return new RDN(attributeTypeAndValue);
    }

    private static RDN[] transfer2DERUTF8String(RDN[] oldRDNs) {
        RDN[] newRDNs = new RDN[oldRDNs.length];
        AttributeTypeAndValue attributeTypeAndValue = null;
        ASN1Encodable value = null;
        int index = 0;
        try {
            for (RDN old : oldRDNs) {
                attributeTypeAndValue = old.getFirst();
                value = attributeTypeAndValue.getValue();
                if (value instanceof DERT61String) {
                    newRDNs[index] = CertificateStandardizedUtil.transfer2UTF8RDN(attributeTypeAndValue.getType(), ((DERT61String)value).getOctets());
                } else if (value instanceof DERPrintableString) {
                    newRDNs[index] = CertificateStandardizedUtil.transfer2UTF8RDN(attributeTypeAndValue.getType(), ((DERPrintableString)value).getOctets());
                } else if (value instanceof DERBMPString) {
                    DERBMPString derbmpString = (DERBMPString)value;
                    DERUTF8String derutf8String = new DERUTF8String(new String(derbmpString.getString().getBytes("UTF-8"), "UTF-8"));
                    newRDNs[index] = CertificateStandardizedUtil.transfer2UTF8RDN(attributeTypeAndValue.getType(), (ASN1Encodable)derutf8String);
                } else {
                    newRDNs[index] = value instanceof DERIA5String ? CertificateStandardizedUtil.transfer2UTF8RDN(attributeTypeAndValue.getType(), ((DERIA5String)value).getOctets()) : (value instanceof DERNumericString ? CertificateStandardizedUtil.transfer2UTF8RDN(attributeTypeAndValue.getType(), ((DERNumericString)value).getOctets()) : old);
                }
                ++index;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return newRDNs;
    }
}

