/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.utils;

import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.utils.CertificateBuilder;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.spongycastle.asn1.ASN1Boolean;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DLSequence;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.asn1.x9.X9ECPoint;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.x509.extension.X509ExtensionUtil;

public class CertificateExtensionUtil {
    public static byte[] getAuthorityKeyIdentifier(String cert) throws IOException, CertificateException {
        X509Certificate x509Certificate = CertificateBuilder.buildCertificate(cert);
        return CertificateExtensionUtil.getAuthorityKeyIdentifier(x509Certificate);
    }

    public static byte[] getAuthorityKeyIdentifier(X509Certificate cert) throws IOException {
        return CertificateExtensionUtil.getSubjectOrAuthorityKeyIdentifier(cert, "2.5.29.35");
    }

    public static byte[] getSubjectKeyIdentifier(String cert) throws IOException, CertificateException {
        X509Certificate x509Certificate = CertificateBuilder.buildCertificate(cert);
        return CertificateExtensionUtil.getSubjectKeyIdentifier(x509Certificate);
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) throws IOException {
        byte[] keyID = null;
        try {
            keyID = CertificateExtensionUtil.getSubjectOrAuthorityKeyIdentifier(cert, "2.5.29.14");
        }
        catch (Exception e) {
            keyID = CertificateExtensionUtil.getKeyIdentifier(cert.getPublicKey());
        }
        return keyID;
    }

    public static SubjectPublicKeyInfo getSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidKeyException {
        SubjectPublicKeyInfo publicKeyInfo = null;
        BCECPublicKey ecPublicKey = null;
        try {
            if (publicKey.getAlgorithm().equals("SM2")) {
                ECPoint Q = null;
                if (publicKey instanceof SM2BCPublicKey) {
                    Q = ((SM2BCPublicKey)((Object)publicKey)).getQ();
                } else if (publicKey instanceof BCECPublicKey) {
                    ecPublicKey = (BCECPublicKey)publicKey;
                    Q = ecPublicKey.getQ();
                } else {
                    throw new InvalidKeyException("unsupported sm2 public key: " + publicKey.getClass().getName());
                }
                publicKeyInfo = CertificateExtensionUtil.buildSM2SubjectPublicKeyInfo(Q);
            } else {
                publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)((ASN1Sequence)new ASN1InputStream(publicKey.getEncoded()).readObject()));
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("fail to get subject public key info,cause:" + e.getMessage());
        }
        return publicKeyInfo;
    }

    private static SubjectPublicKeyInfo buildSM2SubjectPublicKeyInfo(ECPoint Q) {
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(ECDomainParametersHelper.getECCurve().createPoint(Q.getXCoord().toBigInteger(), Q.getYCoord().toBigInteger(), false)).toASN1Primitive();
        return new SubjectPublicKeyInfo(SparkAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, p.getOctets());
    }

    public static byte[] getKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        byte[] keyIdentifier = null;
        try {
            SHA1Digest digest = new SHA1Digest();
            byte[] resBuf = new byte[digest.getDigestSize()];
            byte[] bytes = publicKeyInfo.getPublicKeyData().getBytes();
            digest.update(bytes, 0, bytes.length);
            digest.doFinal(resBuf, 0);
            DEROctetString octKeyIdentifier = new DEROctetString(resBuf);
            keyIdentifier = octKeyIdentifier.getOctets();
        }
        catch (Exception e) {
            throw new IOException("failed to get subject key identifier", e);
        }
        return keyIdentifier;
    }

    public static byte[] getKeyIdentifier(PublicKey publicKey) throws IOException {
        byte[] keyIdentifier = null;
        SubjectPublicKeyInfo publicKeyInfo = null;
        try {
            publicKeyInfo = CertificateExtensionUtil.getSubjectPublicKeyInfo(publicKey);
            SHA1Digest digest = new SHA1Digest();
            byte[] resBuf = new byte[digest.getDigestSize()];
            byte[] bytes = publicKeyInfo.getPublicKeyData().getBytes();
            digest.update(bytes, 0, bytes.length);
            digest.doFinal(resBuf, 0);
            DEROctetString octKeyIdentifier = new DEROctetString(resBuf);
            keyIdentifier = octKeyIdentifier.getOctets();
        }
        catch (Exception e) {
            throw new IOException("failed to get subject key identifier", e);
        }
        return keyIdentifier;
    }

    public static byte[] getSubjectOrAuthorityKeyIdentifier(X509Certificate cert, String oid) throws IOException {
        DEROctetString keyId;
        byte[] akiValue = cert.getExtensionValue(oid);
        switch (akiValue.length) {
            case 24: {
                ASN1OctetString oct = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                keyId = (DEROctetString)DEROctetString.fromByteArray((byte[])oct.getOctets());
                break;
            }
            case 26: {
                ASN1OctetString temValue = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])temValue.getOctets());
                DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                keyId = (DEROctetString)taggedObject.getObject();
                break;
            }
            case 31: {
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                DEROctetString derTag = (DEROctetString)dlSequence.getObjectAt(1);
                keyId = (DEROctetString)DEROctetString.fromByteArray((byte[])derTag.getOctets());
                break;
            }
            case 33: {
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                DEROctetString derTag = (DEROctetString)dlSequence.getObjectAt(1);
                dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])derTag.getOctets());
                DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                keyId = (DEROctetString)taggedObject.getObject();
                break;
            }
            default: {
                try {
                    DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                    DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                    keyId = (DEROctetString)taggedObject.getObject();
                    break;
                }
                catch (ClassCastException ex) {
                    ASN1OctetString tempValue = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                    DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])tempValue.getOctets());
                    DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                    keyId = (DEROctetString)taggedObject.getObject();
                }
            }
        }
        return keyId.getOctets();
    }

    public static void main(String[] ars) throws Exception {
        String v = "MIIDwjCCAyugAwIBAgINAIxL8x1B2SQBp2/PmTANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJDTjEQMA4GA1UEBxMHSmlhbmdTdTESMBAGA1UEChMJU1lBTiBUZWNoMRAwDgYDVQQLEwdTdXBwb3J0MQ8wDQYDVQQDEwZURVNUQ0ExITAfBgNVBC0TGDEyOTE5NTgyMjVVNEQwMUI3RDE0NzlGQzAeFw0xNDA1MjgxNjAwMDBaFw0xNzAzMTcxNjAwMDBaMIGDMQswCQYDVQQGEwJDTjEKMAgGA1UEKhMBRDEiMCAGBFUELRETGEU3NkVCQjUxN0EyNThDNjJEMERGNUYxMTENMAsGA1UEChMEU3lhbjEMMAoGA1UECxMDRGV2MScwJQYDVQQDHh4AQQBuAGQAcgBvAGkAZAAgAEEAcABwACBfAFPRgAUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALxunjkTFtOooqlkOgRwVZfboUA8EzWUVZ0pHditWiwnVhfNXVkKxO7gCE1B+U3DoDXZi/ucDF2sWxWma+WDbx5ZMT93MGM04xzzXZXCBpW4U4HqXPCvl1AlklzVEVd0RJu6Umv4KzLMX9PrBz92viuOEuLSwEW7ZCgxN6da3q+zAgMBAAGjggFBMIIBPTAJBgNVHRMEAjAAMCEGCWCGSAGG+EIBDQQUFhJORVRPTkUgY2VydGlmaWNhdGUwHQYDVR0OBBYEFFS3Ma82RwXVJ5n61/YpIgTmldxzMIGrBgNVHSMEgaMwgaCAFD4pkAnZzjs2p40h/JpErSWetk11oX2kezB5MQswCQYDVQQGEwJDTjEQMA4GA1UEBxMHSmlhbmdTdTESMBAGA1UEChMJU1lBTiBUZWNoMRAwDgYDVQQLEwdTdXBwb3J0MQ8wDQYDVQQDEwZURVNUQ0ExITAfBgNVBC0TGDEyOTE5NTgyMjVVNEQwMUI3RDE0NzlGQ4IJALXgqD3TaX8zMAsGA1UdDwQEAwIE8DAzBgNVHSUELDAqBggrBgEFBQcDAgYIKwYBBQUHAwQGCCsGAQUFBwMIBgorBgEEAYI3CgMEMA0GCSqGSIb3DQEBBQUAA4GBAB8Qt44gKykohOmEa023UezvNaz5Ne1ugk0Lali5GC1HKQu8StQcR1pzaJXvpm+o73HWk8M1L1CDoJpQfq60vdbnundCZe+zmPTXPsTyoNiNxw3NTJ0reVRG7r4LFX1en/Zs6uaAIU2EiC4S4vEAHckzN3Oj3Bfa0azW5PakW3X2";
        X509Certificate x509Certificate = CertificateConverter.fromBase64(v);
        byte[] basicConstraintsBinary = x509Certificate.getExtensionValue("2.5.29.19");
        ASN1Sequence basicConstraints = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue((byte[])basicConstraintsBinary);
        if (basicConstraints.size() < 1) {
            System.out.println("not ca");
            System.exit(0);
        }
        Object isCA = basicConstraints.getObjectAt(0);
        boolean isCACert = false;
        if (isCA instanceof ASN1Boolean) {
            isCACert = isCA.equals(ASN1Boolean.TRUE);
        } else {
            isCA = basicConstraints.getObjectAt(1);
            if (isCA instanceof ASN1Boolean) {
                isCA = isCA.equals(ASN1Boolean.TRUE);
            }
        }
        System.out.println(isCACert);
    }
}

