/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.tsp;

import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import cn.com.syan.jcee.utils.StringConverter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.spongycastle.tsp.TSPException;
import org.spongycastle.tsp.TimeStampResponse;
import org.spongycastle.tsp.TimeStampToken;
import org.spongycastle.tsp.TimeStampTokenInfo;
import org.spongycastle.util.encoders.Base64;

public class TimeStampParser {
    private TimeStampToken token;
    private TimeStampTokenInfo tokenInfo;

    public TimeStampParser(String timeStamp) throws IOException, TSPException {
        TimeStampResponse tsp = new TimeStampResponse(Base64.decode((String)timeStamp));
        this.token = tsp.getTimeStampToken();
        this.tokenInfo = this.token.getTimeStampInfo();
    }

    public BigInteger getNonce() {
        return this.tokenInfo.getNonce();
    }

    public Date getTimestamp() {
        return this.tokenInfo.getGenTime();
    }

    public String getAlgo() {
        String oid = this.tokenInfo.getHashAlgorithm().getAlgorithm().getId();
        return SparkAlgorithmIdentifier.getAlgorithmName(oid);
    }

    public String getImprint() {
        return StringConverter.toHexadecimal((byte[])this.tokenInfo.getMessageImprintDigest());
    }

    public String getSerial() {
        return this.token.getSID().getSerialNumber().toString(16);
    }

    public TimeStampTokenInfo getTimeStampTokenInfo() {
        return this.tokenInfo;
    }
}

