/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.security;

import cn.com.syan.jcee.common.impl.asn1.SM2BCPrivateKey;
import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import java.io.IOException;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class SM2BCKeyPair {
    private SM2BCPrivateKey sm2BCPrivateKey;
    private SM2BCPublicKey sm2BCPublicKey;
    private BCECPublicKey ecPublicKey;
    private BCECPrivateKey ecPrivateKey;

    public SM2BCKeyPair(AsymmetricCipherKeyPair keyPair) throws IOException {
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        this.ecPublicKey = new BCECPublicKey("SM2", publicKeyParameters, BouncyCastleProvider.CONFIGURATION);
        this.ecPrivateKey = new BCECPrivateKey("SM2", privateKeyParameters, this.ecPublicKey, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        this.sm2BCPrivateKey = new SM2BCPrivateKey(this.ecPrivateKey, this.ecPublicKey);
        this.sm2BCPublicKey = new SM2BCPublicKey(this.ecPublicKey.getQ());
    }

    public SM2BCKeyPair(BCECPublicKey publicKey, BCECPrivateKey privateKey) throws IOException {
        this.ecPublicKey = publicKey;
        this.ecPrivateKey = privateKey;
        this.sm2BCPrivateKey = new SM2BCPrivateKey(this.ecPrivateKey, this.ecPublicKey);
        this.sm2BCPublicKey = new SM2BCPublicKey(this.ecPublicKey.getQ());
    }

    public SM2BCPrivateKey getSM2BCPrivateKey() {
        return this.sm2BCPrivateKey;
    }

    public SM2BCPublicKey getSM2BCPublicKey() {
        return this.sm2BCPublicKey;
    }

    public BCECPublicKey getBCECPublicKey() {
        return this.ecPublicKey;
    }

    public BCECPrivateKey getBCECPrivateKey() {
        return this.ecPrivateKey;
    }
}

