/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs7;

import cn.com.syan.jcee.common.impl.SparkSignature;
import cn.com.syan.jcee.common.impl.asn1.chaincert.AuthorizedIdentifyCode;
import cn.com.syan.jcee.common.impl.asn1.chaincert.EndorseData;
import cn.com.syan.jcee.common.impl.asn1.chaincert.ExtKeyUsage;
import cn.com.syan.jcee.common.impl.asn1.chaincert.IdentifyCode;
import cn.com.syan.jcee.common.impl.asn1.chaincert.PrivilegeInfoContent;
import cn.com.syan.jcee.common.impl.asn1.chaincert.PrivilegeValidty;
import cn.com.syan.jcee.common.impl.pkcs7.ChainCertCallBack;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import cn.com.syan.jcee.exception.JCEEException;
import cn.com.syan.jcee.utils.MessageDigestUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.BERSet;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DEROutputStream;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DLSequence;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cert.jcajce.JcaCertStore;
import org.spongycastle.cert.jcajce.JcaX509CertificateHolder;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignedDataStreamGenerator;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.spongycastle.crypto.digests.SM3Digest;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.operator.ContentSigner;
import org.spongycastle.operator.jcajce.JcaContentSignerBuilder;
import org.spongycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.spongycastle.util.Selector;
import org.spongycastle.util.Store;
import org.spongycastle.util.encoders.Base64;

public class PKCS7Signature {
    private X509Certificate signCert;
    private PrivateKey privateKey;
    private byte[] tobeSignedData;
    private List<X509Certificate> certChain;
    private Map chainCertAttributes;
    private boolean isChainCertPKCS7;
    private String merageContentTypeOID;

    public PKCS7Signature() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        this.certChain = new ArrayList<X509Certificate>();
    }

    public void initSign(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void addSigner(X509Certificate signCert) {
        if (signCert != null) {
            this.signCert = signCert;
            this.certChain.add(this.signCert);
        }
    }

    public void addCertificates(List<X509Certificate> certList) {
        if (null != certList) {
            this.certChain.addAll(certList);
        }
    }

    public void update(byte[] data) {
        this.tobeSignedData = data;
    }

    public byte[] sign() throws SignatureException {
        return this.sign(true);
    }

    public byte[] sign(boolean attach) throws SignatureException {
        if (this.signCert == null || this.privateKey == null) {
            throw new NullPointerException("signer cert or private key is null");
        }
        byte[] signedData = null;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            if (this.signCert.getPublicKey().getAlgorithm().equals("RSA")) {
                CMSSignedDataStreamGenerator sdGen = new CMSSignedDataStreamGenerator();
                JcaCertStore certificates = new JcaCertStore(this.certChain);
                sdGen.addCertificates((Store)certificates);
                String signatureAlgorithm = "SHA1withRSA";
                ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(this.privateKey);
                sdGen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("SC").build()).build(signer, this.signCert));
                OutputStream sigOut = sdGen.open((OutputStream)bOut, attach);
                sigOut.write(this.tobeSignedData);
                sigOut.flush();
                sigOut.close();
                signedData = bOut.toByteArray();
            } else {
                SignerInfo signerInfo = this.buildSignerInfo();
                CMSSignedData cmsSignedData = this.buildCMSSignedData(signerInfo, attach);
                signedData = cmsSignedData.getEncoded();
            }
        }
        catch (Exception e) {
            throw new SignatureException("sign pkcs7 failed. cause: " + e.getMessage(), e);
        }
        return signedData;
    }

    public CMSSignedData pkcs7Sign() throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = this.buildSignerInfo();
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData pkcs7ChainCert() throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = this.buildSignerInfo();
        ArrayList<SignerInfo> signerInfoList = new ArrayList<SignerInfo>();
        signerInfoList.add(signerInfo);
        return this.buildChainCertCMSSignedData(this.tobeSignedData, signerInfoList, this.certChain, this.getSignerCert().getPublicKey().getAlgorithm());
    }

    public byte[] pkcs7ChainCertBytes(ChainCertCallBack callBack) throws SignatureException, CertificateEncodingException, IOException {
        SignerInfo signerInfo = this.buildSignerInfo(callBack);
        ArrayList<SignerInfo> signerInfoList = new ArrayList<SignerInfo>();
        signerInfoList.add(signerInfo);
        return this.buildChainCertCMSSignedData(this.tobeSignedData, signerInfoList, this.certChain, this.getSignerCert().getPublicKey().getAlgorithm()).getEncoded();
    }

    public CMSSignedData pkcs7ChainCert(ChainCertCallBack callBack) throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = this.buildSignerInfo(callBack);
        ArrayList<SignerInfo> signerInfoList = new ArrayList<SignerInfo>();
        signerInfoList.add(signerInfo);
        return this.buildChainCertCMSSignedData(this.tobeSignedData, signerInfoList, this.certChain, this.getSignerCert().getPublicKey().getAlgorithm());
    }

    public CMSSignedData pkcs7Sign(boolean attach) throws SignatureException {
        CMSSignedData cmsSignedData;
        try {
            cmsSignedData = new CMSSignedData(this.sign(attach));
        }
        catch (CMSException e) {
            throw new SignatureException(e);
        }
        return cmsSignedData;
    }

    public CMSSignedData pkcs7Sign(ContentSigner contentSigner, boolean attach) throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = null;
        try {
            String publicKeyAlgo = this.getSignerCert().getPublicKey().getAlgorithm();
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(this.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), (ASN1Encodable)DERNull.INSTANCE);
            OutputStream outputStream = contentSigner.getOutputStream();
            DEROutputStream derOutputStream = new DEROutputStream(outputStream);
            derOutputStream.writeObject((ASN1Encodable)authenticatedAttributes);
            outputStream.close();
            byte[] signature = contentSigner.getSignature();
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return this.buildCMSSignedData(signerInfo, attach);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo, boolean attach) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(attach ? this.tobeSignedData : null, signerInfo, this.certChain);
    }

    public CMSSignedData buildCMSSignedData(byte[] data, SignerInfo signerInfo, List<X509Certificate> certList) throws SignatureException, CertificateEncodingException {
        CMSSignedData cmsSignedData = null;
        ASN1EncodableVector digestAlgos = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        boolean rsaAlgo = this.getSignerCert().getPublicKey().getAlgorithm().equals("RSA");
        Object octs = this.isChainCertPKCS7 ? (data == null ? null : new DEROctetString(data)) : (data == null ? null : new BEROctetString(data));
        ContentInfo encInfo = new ContentInfo(rsaAlgo ? CMSObjectIdentifiers.data : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), (ASN1Encodable)octs);
        digestAlgos.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
        signerInfos.add((ASN1Encodable)signerInfo);
        BERSet certificates = null;
        ASN1Set certCRLs = null;
        if (certList.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                Iterator<X509Certificate> it = certList.iterator();
                while (it.hasNext()) {
                    v.add((ASN1Encodable)ASN1Sequence.fromByteArray((byte[])it.next().getEncoded()));
                }
                certificates = new BERSet(v);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgos), encInfo, certificates, certCRLs, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(rsaAlgo ? CMSObjectIdentifiers.signedData : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.2"), (ASN1Encodable)sd);
        try {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            cmsSignedData = new CMSSignedData((CMSProcessable)content, contentInfo);
        }
        catch (CMSException e) {
            throw new SignatureException("pkcs7 sign failed", e);
        }
        return cmsSignedData;
    }

    private SignerInfo buildChainCertSignerInfo(byte[] signature) throws SignatureException {
        SignerInfo signerInfo = null;
        try {
            String publicKeyAlgo = this.getSignerCert().getPublicKey().getAlgorithm();
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(this.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), (ASN1Encodable)DERNull.INSTANCE);
            DEROctetString encryptedDigest = new DEROctetString(signature);
            byte[] akiValue = this.getSignerCert().getExtensionValue("2.5.29.35");
            DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
            DERSet unauthenticatedAttributes = new DERSet((ASN1Encodable)dlSequence);
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, (ASN1Set)unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return signerInfo;
    }

    public CMSSignedData buildChainCertCMSSignedData(byte[] data, List<SignerInfo> signerInfoList, List<X509Certificate> certList, String algorithm) throws SignatureException, CertificateEncodingException {
        CMSSignedData cmsSignedData = null;
        boolean rsaAlgo = algorithm.equalsIgnoreCase("RSA");
        Object octs = this.isChainCertPKCS7 ? (data == null ? null : new DEROctetString(data)) : (data == null ? null : new BEROctetString(data));
        ContentInfo encInfo = new ContentInfo(rsaAlgo ? CMSObjectIdentifiers.data : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), (ASN1Encodable)octs);
        ASN1EncodableVector digestAlgos = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = null;
        if (signerInfoList.size() != 0) {
            for (SignerInfo signerInfo : signerInfoList) {
                algorithmIdentifier = signerInfo.getDigestAlgorithm();
                signerInfos.add((ASN1Encodable)signerInfo);
            }
            digestAlgos.add(algorithmIdentifier);
        }
        BERSet certificates = null;
        ASN1Set certCRLs = null;
        if (certList.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                Iterator<X509Certificate> it = certList.iterator();
                while (it.hasNext()) {
                    v.add((ASN1Encodable)ASN1Sequence.fromByteArray((byte[])it.next().getEncoded()));
                }
                certificates = new BERSet(v);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgos), encInfo, certificates, certCRLs, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(rsaAlgo ? CMSObjectIdentifiers.signedData : new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.2"), (ASN1Encodable)sd);
        try {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            cmsSignedData = new CMSSignedData((CMSProcessable)content, contentInfo);
        }
        catch (CMSException e) {
            throw new SignatureException("pkcs7 sign failed", e);
        }
        return cmsSignedData;
    }

    private SignerInfo buildSignerInfo(ChainCertCallBack callBack) throws SignatureException {
        SignerInfo signerInfo = null;
        try {
            String certBase64;
            String publicKeyAlgo = this.getSignerCert().getPublicKey().getAlgorithm();
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(this.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), (ASN1Encodable)DERNull.INSTANCE);
            byte[] signature = null;
            if (publicKeyAlgo.equals("RSA")) {
                if (callBack != null) {
                    certBase64 = CertificateConverter.toBase64String(this.getSignerCert());
                    signature = callBack.getSignature(authenticatedAttributes.getEncoded(), certBase64);
                } else {
                    Signature sig = Signature.getInstance("SHA1WITHRSA");
                    sig.initSign(this.privateKey);
                    sig.update(this.tobeSignedData);
                    signature = sig.sign();
                }
            } else if (callBack != null) {
                certBase64 = CertificateConverter.toBase64String(this.getSignerCert());
                signature = callBack.getSignature(authenticatedAttributes.getEncoded(), certBase64);
            } else {
                SparkSignature sparkSignature = SparkSignature.getInstance("ECDSASM2withSM3");
                sparkSignature.initSign(this.privateKey);
                sparkSignature.update(authenticatedAttributes.getEncoded());
                signature = sparkSignature.sign((ECPublicKey)this.signCert.getPublicKey());
            }
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return signerInfo;
    }

    private SignerInfo buildSignerInfo() throws SignatureException {
        SignerInfo signerInfo = null;
        try {
            String publicKeyAlgo = this.getSignerCert().getPublicKey().getAlgorithm();
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), (ASN1Encodable)DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(this.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = publicKeyAlgo.equals("RSA") ? new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), (ASN1Encodable)DERNull.INSTANCE);
            byte[] signature = null;
            if (publicKeyAlgo.equals("RSA")) {
                Signature sig = Signature.getInstance("SHA1WITHRSA");
                sig.initSign(this.privateKey);
                sig.update(this.tobeSignedData);
                signature = sig.sign();
            } else {
                SparkSignature sparkSignature = SparkSignature.getInstance("ECDSASM2withSM3");
                sparkSignature.initSign(this.privateKey);
                sparkSignature.update(authenticatedAttributes.getEncoded());
                signature = sparkSignature.sign((ECPublicKey)this.signCert.getPublicKey());
            }
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, (ASN1Set)authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return signerInfo;
    }

    public boolean verify(String pkcs7Data) throws SignatureException {
        return this.verify(pkcs7Data, true);
    }

    public boolean verify(String pkcs7Data, boolean attach) throws SignatureException {
        boolean verResult;
        ByteArrayOutputStream byteStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            if (!attach && this.tobeSignedData == null) {
                throw new SignatureException("\u975eAttach\u6a21\u5f0f\u4e0b,\u5fc5\u987b\u5148update\u5f85\u9a8c\u8bc1\u6570\u636e");
            }
            CMSSignedData sd = new CMSSignedData(Base64.decode((String)pkcs7Data));
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            signedData = contentTypeOID.equals(CMSObjectIdentifiers.data.getId()) ? (attach ? new CMSSignedData(Base64.decode((String)pkcs7Data)) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.tobeSignedData), Base64.decode((String)pkcs7Data))) : (attach ? new CMSSignedData(Base64.decode((String)pkcs7Data)) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), this.tobeSignedData), Base64.decode((String)pkcs7Data)));
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write((OutputStream)byteStream);
                this.tobeSignedData = byteStream.toByteArray();
            }
            Store certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection collection = signers.getSigners();
            Iterator iterator = collection.iterator();
            int verified = 0;
            while (iterator.hasNext()) {
                byte[] nonceFromAttr;
                Attribute nonceAttr;
                ASN1Integer nonceInt;
                BigInteger nonceValue;
                byte[] wholeArray;
                byte[] noncebyte;
                byte[] calculatedMessageDigest;
                byte[] messageDigest;
                DEROctetString messageDigestOct;
                Attribute messageDigestAttr;
                byte[] signedAttributesContent;
                AttributeTable signedAttributes;
                byte[] signature;
                cn.com.syan.jcee.common.impl.cms.SignerInformation signer = cn.com.syan.jcee.common.impl.cms.SignerInformation.getInstance((SignerInformation)iterator.next(), (CMSProcessable)signedContent);
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator it = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)it.next();
                if (contentTypeOID.equals(CMSObjectIdentifiers.data.getId())) {
                    this.signCert = CertificateConverter.fromBinary(cert.getEncoded());
                    signature = signer.getSignature();
                    signedAttributes = signer.getSignedAttributes();
                    signedAttributesContent = null;
                    if (signedAttributes != null) {
                        signedAttributesContent = signer.getEncodedSignedAttributes();
                        messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                        messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                        messageDigest = messageDigestOct.getOctets();
                        calculatedMessageDigest = null;
                        String digestHashAlgorithm = signer.getDigestAlgorithmID().getAlgorithm().getId();
                        if (!"1.3.14.3.2.26".equals(digestHashAlgorithm) && !"2.16.840.1.101.3.4.2.1".equals(digestHashAlgorithm)) {
                            throw new SignatureException("unsupported digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in RSA P7");
                        }
                        calculatedMessageDigest = this.makeDigest((byte[])signedContent.getContent(), signer.getDigestAlgorithmID().getAlgorithm().getId());
                        if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        signedAttributesContent = this.tobeSignedData;
                    }
                    String signatureAlgorithm = this.getRSASignatureAlgorithm(signer.getDigestAlgOID());
                    if (this.innerRSAVerify(signature, signedAttributesContent, this.signCert)) {
                        ++verified;
                    }
                } else {
                    this.signCert = CertificateConverter.fromBinary(cert.toASN1Structure().getEncoded());
                    signature = signer.getSignature();
                    signedAttributes = signer.getSignedAttributes();
                    signedAttributesContent = null;
                    if (signedAttributes != null) {
                        signedAttributesContent = signer.getEncodedSignedAttributes();
                        messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                        messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                        messageDigest = messageDigestOct.getOctets();
                        calculatedMessageDigest = null;
                        if (!"1.2.156.10197.1.401".equals(signer.getDigestAlgorithmID().getAlgorithm().getId())) {
                            throw new SignatureException("invalid digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in SM2 Q7");
                        }
                        calculatedMessageDigest = this.makeSM3DigestWithoutPublicKey((byte[])signedContent.getContent());
                        if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                            boolean digestHashAlgorithm = false;
                            return digestHashAlgorithm;
                        }
                    } else {
                        signedAttributesContent = this.tobeSignedData;
                    }
                    SparkSignature sparkSignature = SparkSignature.getInstance("ECDSASM2withSM3");
                    sparkSignature.initVerify(this.signCert);
                    sparkSignature.update(signedAttributesContent);
                    if (sparkSignature.verify(signature)) {
                        ++verified;
                    }
                }
                if (!this.isChainCertPKCS7 || this.chainCertAttributes == null) continue;
                AttributeTable signedAttributes2 = signer.getSignedAttributes();
                if (this.chainCertAttributes.get("nonce") != null && !Arrays.equals(noncebyte = PKCS7Signature.subByte(wholeArray = (nonceValue = (nonceInt = (ASN1Integer)(nonceAttr = signedAttributes2.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.7"))).getAttrValues().getObjectAt(0)).getValue()).toByteArray(), wholeArray.length - 32, 32), nonceFromAttr = (byte[])this.chainCertAttributes.get("nonce"))) {
                    boolean digestHashAlgorithm = false;
                    return digestHashAlgorithm;
                }
                if (this.chainCertAttributes.get("extKeyUsage") != null) {
                    boolean i;
                    Attribute extKeyUsageAttr = signedAttributes2.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.4"));
                    ASN1Sequence extSequence = (ASN1Sequence)extKeyUsageAttr.getAttrValues().getObjectAt(0);
                    String reason = extSequence.toString();
                    String[] reasonArray = reason.replace("[", "").replace("]", "").replaceAll(" ", "").split(",");
                    String[] identifiers = (String[])this.chainCertAttributes.get("extKeyUsage");
                    boolean isContains = false;
                    for (i = false; i < reasonArray.length; i += 1) {
                        isContains = Arrays.asList(identifiers).contains(reasonArray[i].trim());
                    }
                    if (!isContains) {
                        i = false;
                        return i;
                    }
                }
                Attribute timeAttr = signedAttributes2.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.1"));
                ASN1Sequence timeSequence = (ASN1Sequence)timeAttr.getAttrValues().getObjectAt(0);
                String[] timeArray = timeSequence.toString().replace("[", "").replace("]", "").replaceAll(" ", "").split(",");
                ASN1UTCTime beforeTime = new ASN1UTCTime(timeArray[0].trim());
                Date beforeDate = beforeTime.getAdjustedDate();
                ASN1UTCTime AfterTime = new ASN1UTCTime(timeArray[1].trim());
                Date AfterDate = AfterTime.getAdjustedDate();
                Date nowDate = new Date();
                if (beforeDate.before(nowDate) && AfterDate.after(nowDate)) continue;
                boolean bl = false;
                return bl;
            }
            verResult = verified == collection.size();
        }
        catch (Exception e) {
            throw new SignatureException("\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return verResult;
    }

    public static List<EndorseData> getEndorseDataFromPkcs7(String pkcs7Data) throws SignatureException, IOException, ParseException {
        List<Map<String, Object>> list = PKCS7Signature.getP7Infos(pkcs7Data, true);
        ArrayList<EndorseData> endorseDataList = new ArrayList<EndorseData>();
        for (Map<String, Object> map : list) {
            EndorseData endorseData = new EndorseData();
            endorseData.setNonce((byte[])map.get("nonce"));
            endorseData.setSelectOids((String[])map.get("reason"));
            byte[] privilege = cn.com.syan.jcee.utils.codec.binary.Base64.decodeBase64((String)((String)map.get("privilege")));
            PrivilegeInfoContent privilegeInfoContent = PrivilegeInfoContent.getInstance(privilege);
            endorseData.setApplyName(privilegeInfoContent.getAuthorizedCommonName().toString());
            AuthorizedIdentifyCode authorizedIdentifyCode = privilegeInfoContent.getAuthorizedIdentifyCode();
            endorseData.setApplyType(authorizedIdentifyCode.getTagValue());
            if (authorizedIdentifyCode.getTagValue() == 0) {
                endorseData.setIdNo(authorizedIdentifyCode.getiCregistrationNumber().toString());
            } else if (authorizedIdentifyCode.getTagValue() == 1) {
                IdentifyCode identifyCode = authorizedIdentifyCode.getIdentifyCode();
                endorseData.setIdNoType(identifyCode.getTagValue());
                if (identifyCode.getTagValue() == 1) {
                    endorseData.setIdNo(identifyCode.getMilitaryOfficerCardNumber().toString());
                } else {
                    endorseData.setIdNo(identifyCode.getPrintableString().toString());
                }
            }
            ASN1UTCTime beforeTime = new ASN1UTCTime((String)map.get("notBefore"));
            ASN1UTCTime AfterTime = new ASN1UTCTime((String)map.get("notAfter"));
            endorseData.setBeforeTime(beforeTime.getAdjustedDate());
            endorseData.setAfterTime(AfterTime.getAdjustedDate());
            endorseData.setSubjectKeyIdentifie(privilegeInfoContent.getSubjectKeyIdentifier().getSubject().getEncoded());
            endorseDataList.add(endorseData);
        }
        return endorseDataList;
    }

    public static List<Map<String, Object>> getP7Infos(String pkcs7Data, boolean attach) throws SignatureException {
        ByteArrayOutputStream byteStream = null;
        ArrayList<Map<String, Object>> resultlist = new ArrayList<Map<String, Object>>();
        String tobeSignedData = null;
        X509Certificate x509Cert = null;
        try {
            byteStream = new ByteArrayOutputStream();
            CMSSignedData sd = new CMSSignedData(Base64.decode((String)pkcs7Data));
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            signedData = contentTypeOID.equals(CMSObjectIdentifiers.data.getId()) ? new CMSSignedData(Base64.decode((String)pkcs7Data)) : new CMSSignedData(Base64.decode((String)pkcs7Data));
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write((OutputStream)byteStream);
                tobeSignedData = cn.com.syan.jcee.utils.codec.binary.Base64.encodeBase64String((byte[])byteStream.toByteArray());
            }
            Store certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection collection = signers.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                cn.com.syan.jcee.common.impl.cms.SignerInformation signer = cn.com.syan.jcee.common.impl.cms.SignerInformation.getInstance((SignerInformation)iterator.next(), (CMSProcessable)signedContent);
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator it = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)it.next();
                x509Cert = CertificateConverter.fromBinary(cert.toASN1Structure().getEncoded());
                AttributeTable signedAttributes = signer.getSignedAttributes();
                if (signedAttributes != null) {
                    Attribute nonceAttr = signedAttributes.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.7"));
                    ASN1Integer nonceInt = (ASN1Integer)nonceAttr.getAttrValues().getObjectAt(0);
                    BigInteger nonceValue = nonceInt.getPositiveValue();
                    byte[] wholeArray = nonceValue.toByteArray();
                    byte[] noncebyte = PKCS7Signature.subByte(wholeArray, wholeArray.length - 32, 32);
                    resultMap.put("nonce", noncebyte);
                    Attribute extKeyUsageAttr = signedAttributes.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.4"));
                    ASN1Sequence extSequence = (ASN1Sequence)extKeyUsageAttr.getAttrValues().getObjectAt(0);
                    String reason = extSequence.toString();
                    String[] reasonArray = reason.replace("[", "").replace("]", "").replaceAll(" ", "").split(",");
                    resultMap.put("reason", reasonArray);
                    Attribute timeAttr = signedAttributes.get(new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.1"));
                    ASN1Sequence timeSequence = (ASN1Sequence)timeAttr.getAttrValues().getObjectAt(0);
                    String[] timeArray = timeSequence.toString().replace("[", "").replace("]", "").replaceAll(" ", "").split(",");
                    resultMap.put("reason", reasonArray);
                    resultMap.put("notBefore", timeArray[0].trim());
                    resultMap.put("notAfter", timeArray[1].trim());
                    resultMap.put("certificate", x509Cert);
                    resultMap.put("privilege", tobeSignedData);
                    resultlist.add(resultMap);
                    continue;
                }
                throw new SignatureException("\u65e0\u6cd5\u53d6\u5230P7\u5c5e\u6027");
            }
        }
        catch (Exception e) {
            throw new SignatureException("PKCS7\u7ed3\u6784\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultlist;
    }

    private Map<String, Object> getSignerInfos(byte[] pkcs7Data, boolean attach) throws SignatureException {
        ByteArrayOutputStream byteStream = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<SignerInfo> signerInfoList = new ArrayList<SignerInfo>();
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        try {
            byteStream = new ByteArrayOutputStream();
            if (!attach && this.tobeSignedData == null) {
                throw new SignatureException("\u975eAttach\u6a21\u5f0f\u4e0b,\u5fc5\u987b\u5148update\u5f85\u9a8c\u8bc1\u6570\u636e");
            }
            CMSSignedData sd = new CMSSignedData(pkcs7Data);
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            if (contentTypeOID.equals(CMSObjectIdentifiers.data.getId())) {
                signedData = attach ? new CMSSignedData(pkcs7Data) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.tobeSignedData), pkcs7Data);
            } else {
                CMSSignedData cMSSignedData = signedData = attach ? new CMSSignedData(pkcs7Data) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), this.tobeSignedData), pkcs7Data);
            }
            if (this.merageContentTypeOID != null && !this.merageContentTypeOID.equals(contentTypeOID)) {
                throw new IOException("\u5408\u5e76\u7684\u7b7e\u540d\u7b97\u6cd5\u4e0d\u540c\uff0c\u65e0\u6cd5\u5408\u5e76");
            }
            this.merageContentTypeOID = contentTypeOID;
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write((OutputStream)byteStream);
                byte[] tmpData = byteStream.toByteArray();
                if (this.tobeSignedData != null && !Arrays.equals(this.tobeSignedData, tmpData)) {
                    throw new IOException("\u5408\u5e76\u7684\u7b7e\u540d\u539f\u6587\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5408\u5e76");
                }
                this.tobeSignedData = tmpData;
            }
            Store certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection collection = signers.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                cn.com.syan.jcee.common.impl.cms.SignerInformation signer = cn.com.syan.jcee.common.impl.cms.SignerInformation.getInstance((SignerInformation)iterator.next(), (CMSProcessable)signedContent);
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator it = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)it.next();
                signerInfoList.add(signer.toASN1Structure());
                certificateList.add(CertificateConverter.fromBinary(cert.toASN1Structure().getEncoded()));
            }
        }
        catch (Exception e) {
            throw new SignatureException("\u9a8c\u8bc1PKCS7\u7ed3\u6784\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        resultMap.put("signerinfos", signerInfoList);
        resultMap.put("certificates", certificateList);
        return resultMap;
    }

    public CMSSignedData mergePkcs7(List<byte[]> pkcs7List, boolean attach) throws SignatureException, CertificateEncodingException {
        ArrayList<SignerInfo> signerInfos = new ArrayList<SignerInfo>();
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        String algorithm = null;
        for (int i = 0; i < pkcs7List.size(); ++i) {
            Map<String, Object> resultMap = this.getSignerInfos(pkcs7List.get(i), attach);
            List signerInfoList = (List)resultMap.get("signerinfos");
            List certificateList = (List)resultMap.get("certificates");
            for (SignerInfo signerInfo : signerInfoList) {
                signerInfos.add(signerInfo);
            }
            for (X509Certificate x509Certificate : certificateList) {
                algorithm = x509Certificate.getPublicKey().getAlgorithm();
                certificates.add(x509Certificate);
            }
        }
        return this.buildChainCertCMSSignedData(this.tobeSignedData, signerInfos, certificates, algorithm);
    }

    private String getRSASignatureAlgorithm(String digestAlgorithm) {
        String algorithm = null;
        algorithm = "2.16.840.1.101.3.4.2.1".equals(digestAlgorithm) ? "SHA256withRSA" : ("1.3.14.3.2.26".equals(digestAlgorithm) ? "SHA1withRSA" : digestAlgorithm);
        return algorithm;
    }

    private static String dateToString(String dateStr) {
        ASN1UTCTime time = new ASN1UTCTime(dateStr);
        try {
            Date date = time.getAdjustedDate();
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        }
        catch (ParseException e) {
            return "";
        }
    }

    private byte[] makeDigest(byte[] data, String digestAlgorithmIdentifier) {
        byte[] md = null;
        if (digestAlgorithmIdentifier.equals("1.3.14.3.2.26") || digestAlgorithmIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithmIdentifier);
                messageDigest.update(data);
                md = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        } else if (digestAlgorithmIdentifier.equals("1.2.156.10197.1.401")) {
            md = this.makeSM3DigestWithoutPublicKey(data);
        } else {
            throw new InvalidParameterException("invalid digest algorithm: " + digestAlgorithmIdentifier);
        }
        return md;
    }

    private byte[] makeSM3DigestWithoutPublicKey(byte[] toBeVerifiedData) {
        if (toBeVerifiedData == null) {
            throw new InvalidParameterException("data to be verified must be set first");
        }
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(toBeVerifiedData, 0, toBeVerifiedData.length);
        byte[] md = new byte[32];
        sm3Digest.doFinal(md, 0);
        return md;
    }

    private boolean innerSignatureVerify(byte[] rsaSignature, byte[] data, X509Certificate x509Certificate, String signatureAlgorithm) throws JCEEException {
        boolean result = false;
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm);
            signature.initVerify(x509Certificate);
            signature.update(data);
            result = signature.verify(rsaSignature);
        }
        catch (Exception e) {
            throw new JCEEException("Inner RSA Signature verify failed. cause:" + e.getMessage());
        }
        return result;
    }

    private boolean innerRSAVerify(byte[] rsaSignature, byte[] data, X509Certificate x509Certificate) throws JCEEException {
        try {
            byte[] rawDigest = null;
            byte[] derivedDigest = null;
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, x509Certificate);
            byte[] signature = cipher.doFinal(rsaSignature);
            switch (signature.length) {
                case 35: 
                case 51: {
                    ASN1Sequence signatureSequence = ASN1Sequence.getInstance((Object)signature);
                    ASN1Sequence digestAlgoSeq = (ASN1Sequence)signatureSequence.getObjectAt(0);
                    DEROctetString digestOctectValue = (DEROctetString)signatureSequence.getObjectAt(1);
                    derivedDigest = digestOctectValue.getOctets();
                    ASN1ObjectIdentifier digestAlgoIdentifier = (ASN1ObjectIdentifier)digestAlgoSeq.getObjectAt(0);
                    rawDigest = MessageDigestUtil.digestToBinary((byte[])data, (String)digestAlgoIdentifier.getId());
                    break;
                }
                case 20: {
                    rawDigest = MessageDigestUtil.digestToBinary((byte[])data, (String)"SHA1");
                    derivedDigest = signature;
                    break;
                }
                case 16: {
                    rawDigest = MessageDigestUtil.digestToBinary((byte[])data, (String)"MD5");
                    derivedDigest = signature;
                    break;
                }
                default: {
                    throw new JCEEException("signature with length " + signature.length + " is not supported.");
                }
            }
            return Arrays.equals(rawDigest, derivedDigest);
        }
        catch (Exception e) {
            throw new JCEEException("Inner RSA verify failed. cause:" + e.getMessage());
        }
    }

    private ASN1EncodableVector buildAuthenticatedAttributes(byte[] data, AlgorithmIdentifier digAlgorithm) {
        ASN1EncodableVector contentTypeVector = new ASN1EncodableVector();
        contentTypeVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_contentType);
        ASN1EncodableVector pkcs7Vector = new ASN1EncodableVector();
        pkcs7Vector.add((ASN1Encodable)PKCSObjectIdentifiers.data);
        contentTypeVector.add((ASN1Encodable)new DERSet(pkcs7Vector));
        DERSequence contentTypeSequence = new DERSequence(contentTypeVector);
        ASN1EncodableVector sigTimeVector = new ASN1EncodableVector();
        sigTimeVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        ASN1EncodableVector timeVector = new ASN1EncodableVector();
        timeVector.add((ASN1Encodable)new ASN1UTCTime(new Date()));
        sigTimeVector.add((ASN1Encodable)new DERSet(timeVector));
        DERSequence sigTimeSequence = new DERSequence(sigTimeVector);
        ASN1EncodableVector messageDigestVector = new ASN1EncodableVector();
        messageDigestVector.add((ASN1Encodable)PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        ASN1EncodableVector digestVector = new ASN1EncodableVector();
        byte[] messageDigest = this.makeDigest(data, digAlgorithm.getAlgorithm().getId());
        digestVector.add((ASN1Encodable)new DEROctetString(messageDigest));
        messageDigestVector.add((ASN1Encodable)new DERSet(digestVector));
        DERSequence messageDigestSequence = new DERSequence(messageDigestVector);
        ASN1EncodableVector attrVector = new ASN1EncodableVector();
        attrVector.add((ASN1Encodable)contentTypeSequence);
        attrVector.add((ASN1Encodable)sigTimeSequence);
        attrVector.add((ASN1Encodable)messageDigestSequence);
        if (this.isChainCertPKCS7 && this.chainCertAttributes != null) {
            if (this.chainCertAttributes.get("authKey") != null && ((Boolean)this.chainCertAttributes.get("authKey")).booleanValue()) {
                byte[] b = this.signCert.getPublicKey().getEncoded();
                byte[] digest = this.makeDigest(b, digAlgorithm.getAlgorithm().getId());
                ASN1EncodableVector authorityKeyVector = new ASN1EncodableVector();
                authorityKeyVector.add((ASN1Encodable)new ASN1ObjectIdentifier("2.5.29.35"));
                DEROctetString octetString = new DEROctetString(digest);
                DERTaggedObject taggedObject = new DERTaggedObject(false, 0, (ASN1Encodable)octetString);
                DLSequence sequence = new DLSequence((ASN1Encodable)taggedObject);
                try {
                    BEROctetString octs = new BEROctetString(sequence.getEncoded());
                    authorityKeyVector.add((ASN1Encodable)new DERSet((ASN1Encodable)octs));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                DERSequence authorityKeySequence = new DERSequence(authorityKeyVector);
                attrVector.add((ASN1Encodable)authorityKeySequence);
            }
            byte[] nonce = (byte[])this.chainCertAttributes.get("nonce");
            ASN1EncodableVector nonceVector = new ASN1EncodableVector();
            nonceVector.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.7"));
            ASN1EncodableVector nVector = new ASN1EncodableVector();
            nVector.add((ASN1Encodable)new ASN1Integer(new BigInteger(nonce)));
            nonceVector.add((ASN1Encodable)new DERSet(nVector));
            DERSequence nonceSequence = new DERSequence(nonceVector);
            String[] identifiers = (String[])this.chainCertAttributes.get("extKeyUsage");
            ExtKeyUsage extKeyUsage = new ExtKeyUsage(identifiers);
            Date notBefore = (Date)this.chainCertAttributes.get("notBefore");
            Date notAfter = (Date)this.chainCertAttributes.get("notAfter");
            PrivilegeValidty privilegeValidty = new PrivilegeValidty(notBefore, notAfter);
            ASN1EncodableVector privilegeValidtyVector = new ASN1EncodableVector();
            privilegeValidtyVector.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.156.112620.2.1.9.30.1"));
            ASN1EncodableVector validtyVector = new ASN1EncodableVector();
            validtyVector.add((ASN1Encodable)privilegeValidty);
            privilegeValidtyVector.add((ASN1Encodable)new DERSet(validtyVector));
            DERSequence privilegeValidtySequence = new DERSequence(privilegeValidtyVector);
            attrVector.add((ASN1Encodable)nonceSequence);
            attrVector.add((ASN1Encodable)extKeyUsage);
            attrVector.add((ASN1Encodable)privilegeValidtySequence);
        }
        return attrVector;
    }

    private DERSet buildUnAuthenticatedAttributes(AlgorithmIdentifier digAlgorithm) {
        byte[] b = this.signCert.getPublicKey().getEncoded();
        byte[] digest = this.makeDigest(b, digAlgorithm.getAlgorithm().getId());
        String id_ce = "2.5.29.35";
        ASN1ObjectIdentifier authority = new ASN1ObjectIdentifier(id_ce);
        DEROctetString octetString = new DEROctetString(digest);
        DERTaggedObject taggedObject = new DERTaggedObject(false, 0, (ASN1Encodable)octetString);
        BEROctetString octs = null;
        try {
            octs = new BEROctetString(taggedObject.getEncoded());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)authority);
        DERSet asn1Set = new DERSet((ASN1Encodable)octs);
        v.add((ASN1Encodable)asn1Set);
        DLSequence sequence = new DLSequence(v);
        return new DERSet((ASN1Encodable)sequence);
    }

    public X509Certificate getSignerCert() {
        return this.signCert;
    }

    public byte[] getPrimaryContent() {
        return this.tobeSignedData;
    }

    public void setChainCertAttributes(Map chainCertAttributes) {
        this.chainCertAttributes = chainCertAttributes;
    }

    public void setChainCertPKCS7(boolean chainCertPKCS7) {
        this.isChainCertPKCS7 = chainCertPKCS7;
    }

    private static byte[] subByte(byte[] b, int off, int length) {
        byte[] b1 = new byte[length];
        System.arraycopy(b, off, b1, 0, length);
        return b1;
    }
}

