/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs12;

import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.utils.CertificateExtensionUtil;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.engines.DESedeEngine;
import org.spongycastle.crypto.engines.RC2Engine;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.spongycastle.pkcs.PKCS12PfxPdu;
import org.spongycastle.pkcs.PKCS12PfxPduBuilder;
import org.spongycastle.pkcs.PKCS12SafeBag;
import org.spongycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.spongycastle.pkcs.bc.BcPKCS12PBEOutputEncryptorBuilder;
import org.spongycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;

public class SM2PfxBuilder {
    public byte[] buildSM2Pfx(X509Certificate x509Certificate, PrivateKey privateKey, char[] password) throws GeneralSecurityException {
        try {
            SM2BCPublicKey publicKey = (SM2BCPublicKey)((Object)x509Certificate.getPublicKey());
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            JcaPKCS12SafeBagBuilder eeCertBagBuilder = new JcaPKCS12SafeBagBuilder(x509Certificate);
            SubjectPublicKeyInfo spi = CertificateExtensionUtil.getSubjectPublicKeyInfo((PublicKey)((Object)publicKey));
            eeCertBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(spi));
            JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(privateKey, new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine())).build(password));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(spi));
            PKCS12PfxPduBuilder pfxPduBuilder = new PKCS12PfxPduBuilder();
            PKCS12SafeBag[] certs = new PKCS12SafeBag[]{eeCertBagBuilder.build()};
            pfxPduBuilder.addEncryptedData(new BcPKCS12PBEOutputEncryptorBuilder(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, (BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine())).build(password), certs);
            pfxPduBuilder.addData(keyBagBuilder.build());
            PKCS12PfxPdu pfx = pfxPduBuilder.build((PKCS12MacCalculatorBuilder)new BcPKCS12MacCalculatorBuilder(), password);
            return pfx.getEncoded();
        }
        catch (Exception e) {
            throw new GeneralSecurityException("\u6784\u9020SM2\u7b97\u6cd5PFX\u8bc1\u4e66\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
    }
}

