/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs12;

import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.key.SparkECPrivateKey;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import cn.com.syan.jcee.common.impl.utils.PrivateKeyBuilder;
import cn.com.syan.jcee.common.impl.x509.SM2X509Certificate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.pkcs.ContentInfo;
import org.spongycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.pkcs.Pfx;
import org.spongycastle.asn1.pkcs.PrivateKeyInfo;
import org.spongycastle.asn1.pkcs.SafeBag;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.operator.InputDecryptorProvider;
import org.spongycastle.operator.bc.BcDefaultDigestProvider;
import org.spongycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.spongycastle.pkcs.PKCS12PfxPdu;
import org.spongycastle.pkcs.PKCS12SafeBag;
import org.spongycastle.pkcs.PKCS12SafeBagFactory;
import org.spongycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.spongycastle.pkcs.PKCSException;
import org.spongycastle.pkcs.bc.BcPKCS12MacCalculatorBuilderProvider;
import org.spongycastle.pkcs.bc.BcPKCS12PBEInputDecryptorProviderBuilder;

public class SM2Pfx {
    private String algorithm = "SM2";
    private List<X509Certificate> certificateList = new ArrayList<X509Certificate>();
    private ECPrivateKey privateKey;
    private X509Certificate x509Certificate;

    public void loadKeyStore(byte[] pfxBinary, char[] password) throws KeyStoreException {
        Pfx pfx = Pfx.getInstance((Object)pfxBinary);
        PKCS12PfxPdu pdu = new PKCS12PfxPdu(pfx);
        BcPKCS12MacCalculatorBuilderProvider macCalcProviderBuilder = new BcPKCS12MacCalculatorBuilderProvider(BcDefaultDigestProvider.INSTANCE);
        try {
            if (!pdu.isMacValid((PKCS12MacCalculatorBuilderProvider)macCalcProviderBuilder, password)) {
                throw new Exception("invalid password!");
            }
            ContentInfo[] contentInfos = pdu.getContentInfos();
            BcPKCS12PBEInputDecryptorProviderBuilder idpBuilder = new BcPKCS12PBEInputDecryptorProviderBuilder();
            InputDecryptorProvider inputDecryptorProvider = idpBuilder.build(password);
            for (ContentInfo contentInfo : contentInfos) {
                ASN1ObjectIdentifier oid = contentInfo.getContentType();
                if (oid.equals((Object)PKCSObjectIdentifiers.encryptedData)) {
                    this.x509Certificate = this.parseCertificate(contentInfo, inputDecryptorProvider);
                    continue;
                }
                if (!oid.equals((Object)PKCSObjectIdentifiers.data)) continue;
                this.privateKey = this.parsePrivateKey(contentInfo, inputDecryptorProvider);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("fail to load key store, cause:" + e.getMessage());
        }
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    private X509Certificate parseCertificate(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, CertificateException {
        PKCS12SafeBag[] safeBags;
        X509Certificate x509Certificate = null;
        PKCS12SafeBagFactory factory = new PKCS12SafeBagFactory(contentInfo, inputDecryptorProvider);
        for (PKCS12SafeBag sfb : safeBags = factory.getSafeBags()) {
            if (!sfb.getType().equals((Object)PKCSObjectIdentifiers.certBag)) continue;
            X509CertificateHolder certificateHolder = (X509CertificateHolder)sfb.getBagValue();
            x509Certificate = CertificateConverter.fromBinary(certificateHolder.getEncoded());
            this.certificateList.add(x509Certificate);
        }
        return x509Certificate;
    }

    private ECPrivateKey parsePrivateKey(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, InvalidKeyException {
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)((ASN1OctetString)contentInfo.getContent()).getOctets());
        SafeBag sb = SafeBag.getInstance((Object)sequence.getObjectAt(0));
        EncryptedPrivateKeyInfo encInfo = EncryptedPrivateKeyInfo.getInstance((Object)sb.getBagValue());
        PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(encInfo);
        PrivateKeyInfo privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
        SparkECPrivateKey sparkECPrivateKey = PrivateKeyBuilder.buildSparkECPrivateKey(privateKeyInfo.getEncoded());
        return sparkECPrivateKey.getECPrivateKey();
    }

    public static void main(String[] args) throws Exception {
        String sm2PfxFile = "/Users/Iceberg/Downloads/sm2.pfx";
        String password = "";
        byte[] sm2PfxBinary = IOUtils.toByteArray((InputStream)new FileInputStream(sm2PfxFile));
        SM2Pfx sm2Pfx = new SM2Pfx();
        sm2Pfx.loadKeyStore(sm2PfxBinary, password.toCharArray());
        SM2X509Certificate x509Certificate = (SM2X509Certificate)sm2Pfx.getX509Certificate();
        SM2BCPublicKey publicKey = (SM2BCPublicKey)((Object)x509Certificate.getPublicKey());
        ECPrivateKey privateKey = sm2Pfx.getPrivateKey();
        System.out.println(111);
    }
}

