/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class PKIKeyStore {
    private static KeyStore keyStore = null;
    private char[] pin = null;

    public PKIKeyStore() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        this.initialize();
    }

    public PKIKeyStore(String type) {
        try {
            keyStore = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    public PKIKeyStore(String type, String provider) throws NoSuchProviderException {
        try {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
            type = type == null ? "PKCS12" : type;
            keyStore = KeyStore.getInstance(type, provider);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        try {
            keyStore = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadKeyStore(InputStream input, char[] _pin) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.pin = _pin;
        keyStore.load(input, this.pin);
    }

    public List<X509Certificate> getCertificateChain() throws KeyStoreException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements()) {
            String alias = enu.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            for (Certificate cert : keyStore.getCertificateChain(alias)) {
                chain.add((X509Certificate)cert);
            }
        }
        return chain.size() > 0 ? chain : null;
    }

    public X509Certificate getCertificate() throws KeyStoreException {
        Certificate cert = null;
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements()) {
            String alias = enu.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            cert = keyStore.getCertificate(alias);
            break;
        }
        return (X509Certificate)cert;
    }

    public PrivateKey getPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String alias;
        PrivateKey prvKey = null;
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements() && (!keyStore.isKeyEntry(alias = enu.nextElement()) || (prvKey = (PrivateKey)keyStore.getKey(alias, this.pin)) == null)) {
        }
        return prvKey;
    }
}

