/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs10;

import cn.com.syan.jcee.common.impl.SparkSignature;
import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.pkcs.Attribute;
import org.spongycastle.asn1.pkcs.CertificationRequest;
import org.spongycastle.asn1.pkcs.CertificationRequestInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.Extension;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.operator.ContentSigner;
import org.spongycastle.pkcs.PKCS10CertificationRequest;

public class PKCS10CertificateRequestBuilder {
    public static CertificationRequestInfo buildCertificationRequestInfo(X500Name x500Name, BCECPublicKey publicKey) {
        SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(publicKey.getQ());
        byte[] xx = sm2BCPublicKey.getEncoded();
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(SparkAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
        return new CertificationRequestInfo(x500Name, publicKeyInfo, null);
    }

    public static PKCS10CertificationRequest buildPKCS10CertificationRequest(X500Name x500Name, BCECPublicKey publicKey, ECPrivateKey privateKey) throws SignatureException, InvalidKeyException {
        CertificationRequestInfo requestInfo = PKCS10CertificateRequestBuilder.buildCertificationRequestInfo(x500Name, publicKey);
        return new PKCS10CertificationRequest(PKCS10CertificateRequestBuilder.buildCertificationRequest(requestInfo, (ECPublicKey)publicKey, privateKey));
    }

    public static CertificationRequest buildCertificationRequest(CertificationRequestInfo requestInfo, ECPublicKey publicKey, ECPrivateKey privateKey) throws InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest = null;
        try {
            SparkSignature sparkSignature = SparkSignature.getInstance("ECDSASM2withSM3");
            sparkSignature.initSign((PrivateKey)privateKey);
            sparkSignature.update(requestInfo.getEncoded());
            SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(publicKey.getQ());
            byte[] signature = sparkSignature.sign(sm2BCPublicKey);
            certificationRequest = new CertificationRequest(requestInfo, SparkAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        return PKCS10CertificateRequestBuilder.buildCertificationRequest(x500Name, null, publicKey, privateKey);
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, List<Extension> extensionRequest, PublicKey publicKey, ContentSigner contentSigner) {
        CertificationRequest certificationRequest = null;
        ASN1Set attributes = PKCS10CertificateRequestBuilder.buildExtension(extensionRequest);
        OutputStream outputStream = null;
        try {
            if (publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                outputStream = contentSigner.getOutputStream();
                outputStream.write(requestInfo.getEncoded());
                byte[] signature = contentSigner.getSignature();
                certificationRequest = new CertificationRequest(requestInfo, new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature));
            } else {
                SM2BCPublicKey sm2BCPublicKey = publicKey instanceof SM2BCPublicKey ? (SM2BCPublicKey)((Object)publicKey) : new SM2BCPublicKey(((BCECPublicKey)publicKey).getQ());
                SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(SparkAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                outputStream = contentSigner.getOutputStream();
                outputStream.write(requestInfo.getEncoded());
                byte[] signature = contentSigner.getSignature();
                certificationRequest = new CertificationRequest(requestInfo, SparkAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
            }
        }
        catch (Exception e) {
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    private static ASN1Set buildExtension(List<Extension> extensionRequest) {
        DERSet attributes = null;
        if (extensionRequest != null && extensionRequest.size() > 0) {
            Extension[] extensions = new Extension[extensionRequest.size()];
            extensionRequest.toArray(extensions);
            Attribute extensionRequestAttribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable[])extensions));
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)extensionRequestAttribute);
            attributes = new DERSet(vec);
        }
        return attributes;
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, List<Extension> extensionRequest, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest = null;
        ASN1Set attributes = PKCS10CertificateRequestBuilder.buildExtension(extensionRequest);
        try {
            if (publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                Signature signer = Signature.getInstance("SHA1WITHRSA");
                signer.initSign(privateKey);
                signer.update(requestInfo.getEncoded());
                byte[] signature = signer.sign();
                certificationRequest = new CertificationRequest(requestInfo, new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature));
            } else {
                SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(((BCECPublicKey)publicKey).getQ());
                SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(SparkAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                SparkSignature sparkSignature = SparkSignature.getInstance("ECDSASM2withSM3");
                sparkSignature.initSign(privateKey);
                sparkSignature.update(requestInfo.getEncoded());
                byte[] signature = sparkSignature.sign(sm2BCPublicKey);
                certificationRequest = new CertificationRequest(requestInfo, SparkAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
            }
        }
        catch (Exception e) {
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    public static PKCS10CertificationRequest buildPKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        return new PKCS10CertificationRequest(PKCS10CertificateRequestBuilder.buildCertificationRequest(x500Name, publicKey, privateKey));
    }
}

