/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.pkcs1;

import cn.com.syan.jcee.common.impl.SparkMessageDigest;
import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import javax.crypto.Cipher;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.DigestInfo;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class PKCS1Signature {
    public static final String RSA_CIPHER = "RSA/NONE/PKCS1Padding";
    private PrivateKey privateKey;
    SparkMessageDigest smd = null;
    private Cipher cipher = null;
    private byte[] tobeSignedData = null;

    public PKCS1Signature(String algorithm) throws NoSuchAlgorithmException {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        if (!SparkAlgorithmIdentifier.hasAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException("algorithm " + algorithm + " is not supported");
        }
        if (!algorithm.equalsIgnoreCase("SHA1withDSA")) {
            if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
                this.smd = SparkMessageDigest.getInstance("1.3.14.3.2.26");
            } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
                this.smd = SparkMessageDigest.getInstance("2.16.840.1.101.3.4.2.1");
            } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
                this.smd = SparkMessageDigest.getInstance("2.16.840.1.101.3.4.2.2");
            } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
                this.smd = SparkMessageDigest.getInstance("2.16.840.1.101.3.4.2.3");
            } else {
                throw new NoSuchAlgorithmException("algorithm " + algorithm + " is not supported");
            }
        }
    }

    public void initSign(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void update(byte[] data) throws IOException {
        this.tobeSignedData = this.getDigestInfo(data).getEncoded();
    }

    private DigestInfo getDigestInfo(byte[] data) {
        byte[] md = this.smd.digest(data);
        return new DigestInfo(AlgorithmIdentifier.getInstance((Object)this.smd.getAlgorithmIdentifier()), md);
    }

    public byte[] sign() throws InvalidKeyException, SignatureException {
        byte[] signature = null;
        try {
            if (this.privateKey == null) {
                throw new InvalidKeyException("private key cannot be null");
            }
            this.cipher = Cipher.getInstance(RSA_CIPHER);
            this.cipher.init(1, this.privateKey);
            this.cipher.update(this.tobeSignedData);
            signature = this.cipher.doFinal();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign with private key. cause: " + e.getMessage(), e);
        }
        return signature;
    }

    public byte[] sign(byte[] data) throws InvalidKeyException, SignatureException {
        byte[] signature = null;
        try {
            if (this.privateKey == null) {
                throw new InvalidKeyException("private key cannot be null");
            }
            this.cipher = Cipher.getInstance(RSA_CIPHER);
            this.cipher.init(1, this.privateKey);
            this.tobeSignedData = this.getDigestInfo(data).getEncoded();
            this.cipher.update(this.tobeSignedData);
            signature = this.cipher.doFinal();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign with private key. cause: " + e.getMessage(), e);
        }
        return signature;
    }
}

