/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key.struct;

import cn.com.syan.jcee.common.impl.asn1.ec.SM2Cipher;
import cn.com.syan.jcee.common.impl.asn1.ec.SM2EnvelopedKey;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;

public class EnvelopedSM2KeyBlob {
    private int version = 1;
    private int symmAlgID;
    private int bits;
    private byte[] encryptedPrivateKey;
    private SM2BCPublicKey ecPublicKey;
    private SM2Cipher ecCipherBlob;
    final int VERSION_LEN = 4;
    final int SYMMALGID_LEN = 4;
    final int BITS_LEN = 4;

    public static EnvelopedSM2KeyBlob getInstance(Object envelopedKeyBlob) throws GeneralSecurityException, IOException {
        if (envelopedKeyBlob instanceof ASN1Sequence) {
            return new EnvelopedSM2KeyBlob((ASN1Sequence)envelopedKeyBlob);
        }
        if (envelopedKeyBlob instanceof byte[]) {
            return new EnvelopedSM2KeyBlob((byte[])envelopedKeyBlob);
        }
        throw new IllegalArgumentException("unknown enveloped key blob:" + envelopedKeyBlob.getClass().getName());
    }

    public EnvelopedSM2KeyBlob(byte[] envelopedKeyBlob) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byteVersion = new byte[4];
        System.arraycopy(envelopedKeyBlob, 0, byteVersion, 0, 4);
        this.version = ByteBuffer.wrap(byteVersion).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] byteSymmAlgID = new byte[4];
        System.arraycopy(envelopedKeyBlob, 4, byteSymmAlgID, 0, 4);
        this.symmAlgID = ByteBuffer.wrap(byteSymmAlgID).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] byteBits = new byte[4];
        System.arraycopy(envelopedKeyBlob, 8, byteBits, 0, 4);
        this.bits = ByteBuffer.wrap(byteBits).order(ByteOrder.LITTLE_ENDIAN).getInt();
        SM2EnvelopedKey envelopedKey = new SM2EnvelopedKey(envelopedKeyBlob);
        this.ecPublicKey = new SM2BCPublicKey(envelopedKey.getSM2PublicKey().getOctets());
        this.ecCipherBlob = envelopedKey.getSymEncryptedKey();
        this.encryptedPrivateKey = envelopedKey.getSM2EncryptedPrivateKey().getOctets();
    }

    private EnvelopedSM2KeyBlob(ASN1Sequence sequence) throws GeneralSecurityException, IOException {
        SM2EnvelopedKey envelopedKey = SM2EnvelopedKey.getInstance(sequence);
        AlgorithmIdentifier symmAlgoID = envelopedKey.getSymAlgoID();
        this.symmAlgID = symmAlgoID.getAlgorithm().getId().startsWith("1.2.156.10197.1.104") ? 1025 : -127;
        this.ecPublicKey = new SM2BCPublicKey(envelopedKey.getSM2PublicKey().getOctets());
        this.ecCipherBlob = envelopedKey.getSymEncryptedKey();
        this.encryptedPrivateKey = envelopedKey.getSM2EncryptedPrivateKey().getOctets();
    }

    public int getVersion() {
        return this.version;
    }

    public int getSymmAlgID() {
        return this.symmAlgID;
    }

    public int getBits() {
        return this.bits;
    }

    public byte[] getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public SM2BCPublicKey getECPublicKey() {
        return this.ecPublicKey;
    }

    public SM2Cipher getWrappedKey() {
        return this.ecCipherBlob;
    }
}

