/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class RSAPublicKeyGenerator {
    public static PublicKey buildPublicKey(byte[] binaryKeyValue, String provider) throws InvalidKeyException {
        PublicKey publicKey = null;
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(binaryKeyValue);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance(provider);
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new InvalidKeyException("failed to generate public key,cause: " + e.getMessage(), e);
        }
        return publicKey;
    }

    public static PublicKey buildPublicKey(byte[] binaryKeyValue) throws InvalidKeyException {
        return RSAPublicKeyGenerator.buildPublicKey(binaryKeyValue, null);
    }
}

