/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.key;

import cn.com.syan.jcee.exception.JCEEException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.spongycastle.asn1.pkcs.EncryptionScheme;
import org.spongycastle.asn1.pkcs.KeyDerivationFunc;
import org.spongycastle.asn1.pkcs.PBES2Parameters;
import org.spongycastle.asn1.pkcs.PBKDF2Params;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;

public class PKCS5PBES2 {
    private String keyAlgo = "PBKDF2WithHmacSHA1";
    private int keySize = 128;
    private int iterationCount = 2048;
    private final String CIPHER_ALGO = "AES/ECB/PKCS5Padding";

    public byte[] encrypt(byte[] data, char[] password) throws InvalidKeyException, JCEEException {
        byte[] epkiData = null;
        byte[] salt = PKCS5PBES2.getSalt();
        SecretKey secretKey = this.deriveSecretKey(password, salt, this.iterationCount);
        byte[] encryptedData = this.encryptOrDecrypt(data, secretKey, 1);
        AlgorithmIdentifier pkcs5PBES2Identifier = this.buildPBES2Identifier(salt, this.iterationCount);
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(pkcs5PBES2Identifier, encryptedData);
        try {
            epkiData = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (IOException e) {
            throw new JCEEException("fail to encrypt data, cause " + e.getMessage(), (Throwable)e);
        }
        return epkiData;
    }

    public byte[] decrypt(byte[] encryptedPrivateKeyInfoBinary, char[] password) throws InvalidKeyException, JCEEException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)encryptedPrivateKeyInfoBinary);
        PBKDF2Params pbkdf2Params = this.parse(encryptedPrivateKeyInfo);
        byte[] salt = pbkdf2Params.getSalt();
        int iteration = pbkdf2Params.getIterationCount().intValue();
        SecretKey secretKey = this.deriveSecretKey(password, salt, iteration);
        return this.encryptOrDecrypt(encryptedPrivateKeyInfo.getEncryptedData(), secretKey, 2);
    }

    private AlgorithmIdentifier buildPBES2Identifier(byte[] salt, int iterationCount) {
        ASN1ObjectIdentifier pbkdf2Identifier = new ASN1ObjectIdentifier("1.2.840.113549.1.5.12");
        PBKDF2Params pbkdf2Params = new PBKDF2Params(salt, iterationCount);
        KeyDerivationFunc keyDerivationFunc = new KeyDerivationFunc(pbkdf2Identifier, (ASN1Encodable)pbkdf2Params);
        ASN1ObjectIdentifier encryptionIdentifier = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.1");
        EncryptionScheme scheme = new EncryptionScheme(encryptionIdentifier, (ASN1Encodable)new DEROctetString(new byte[0]));
        PBES2Parameters pbes2Parameters = new PBES2Parameters(keyDerivationFunc, scheme);
        ASN1ObjectIdentifier pbes2Identifier = new ASN1ObjectIdentifier("1.2.840.113549.1.5.13");
        return new AlgorithmIdentifier(pbes2Identifier, (ASN1Encodable)pbes2Parameters);
    }

    private byte[] encryptOrDecrypt(byte[] data, SecretKey secretKey, int mode) throws JCEEException {
        byte[] encryptedData = null;
        int cipherMode = mode == 1 ? 1 : 2;
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(cipherMode, secretKey);
            encryptedData = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new JCEEException("fail to encrypt data, cause " + e.getMessage(), (Throwable)e);
        }
        return encryptedData;
    }

    private SecretKey deriveSecretKey(char[] password, byte[] salt, int iteration) throws InvalidKeyException {
        SecretKey secretKey = null;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.keyAlgo);
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iteration, this.keySize);
            secretKey = secretKeyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new InvalidKeyException("fail to derive secret key, cause:" + e.getMessage(), e);
        }
        return secretKey;
    }

    private static byte[] getSalt() {
        byte[] salt = new byte[16];
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.nextBytes(salt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return salt;
    }

    private PBKDF2Params parse(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        PBKDF2Params pbkdf2Params = null;
        AlgorithmIdentifier algorithmIdentifier = encryptedPrivateKeyInfo.getEncryptionAlgorithm();
        PBES2Parameters pbes2Parameters = PBES2Parameters.getInstance((Object)algorithmIdentifier.getParameters());
        pbkdf2Params = PBKDF2Params.getInstance((Object)pbes2Parameters.getKeyDerivationFunc().getParameters());
        return pbkdf2Params;
    }
}

