/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc.sm2;

import cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature;
import cn.com.syan.jcee.common.impl.ecc.sm2.SM2Result;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.digests.SM3Digest;
import org.spongycastle.crypto.generators.ECKeyPairGenerator;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyGenerationParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;

public class SM2 {
    public BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public ECCurve ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
    public ECPoint ecc_point_g = this.ecc_curve.createPoint(this.ecc_gx, this.ecc_gy);
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public ECDomainParameters ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
    public ECKeyPairGenerator ecc_key_pair_generator;

    private SM2() {
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public static SM2 getInstance() {
        return new SM2();
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        return this.sm2GetZ(userId, userKey.getAffineXCoord().toBigInteger(), userKey.getAffineYCoord().toBigInteger());
    }

    private byte[] sm2GetZ(byte[] userId, BigInteger x, BigInteger y) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = this.ecc_a.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_b.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_gx.toByteArray();
        sm3.update(p, 0, p.length);
        p = this.ecc_gy.toByteArray();
        sm3.update(p, 0, p.length);
        p = x.toByteArray();
        sm3.update(p, 0, p.length);
        p = y.toByteArray();
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public void sm2Sign(byte[] md, BigInteger userD, SM2Result sm2Ret) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.getX().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Ret.r = r;
        sm2Ret.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint userKey, SM2Signature sm2Signature, SM2Result sm2Ret) {
        sm2Ret.R = null;
        BigInteger r = sm2Signature.getR().getValue();
        BigInteger s = sm2Signature.getS().getValue();
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        sm2Ret.R = e.add(x1y1.getX().toBigInteger()).mod(this.ecc_n);
    }
}

