/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc.digest;

import java.math.BigInteger;

public class SM2EllipticCurveParameters {
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger Gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger Gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);

    public static byte[] getP() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(p);
    }

    public static byte[] getA() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(a);
    }

    public static byte[] getB() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(b);
    }

    public static byte[] getN() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(n);
    }

    public static byte[] getGx() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(Gx);
    }

    public static byte[] getGy() {
        return SM2EllipticCurveParameters.asUnsigned32ByteArray(Gy);
    }

    public static byte[] IntToByte(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int ByteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] LongToByte(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] asUnsigned32ByteArray(BigInteger n) {
        return SM2EllipticCurveParameters.asUnsignedNByteArray(n, 32);
    }

    public static byte[] asUnsignedNByteArray(BigInteger x, int length) {
        if (x == null) {
            return null;
        }
        byte[] tmp = new byte[length];
        int len = x.toByteArray().length;
        if (len > length + 1) {
            return null;
        }
        if (len == length + 1) {
            if (x.toByteArray()[0] != 0) {
                return null;
            }
            System.arraycopy(x.toByteArray(), 1, tmp, 0, length);
            return tmp;
        }
        System.arraycopy(x.toByteArray(), 0, tmp, length - len, len);
        return tmp;
    }
}

