/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc.cipher;

import cn.com.syan.jcee.common.impl.ecc.cipher.Hex;
import cn.com.syan.jcee.common.impl.ecc.cipher.SupportClass;
import org.spongycastle.crypto.digests.GeneralDigest;
import org.spongycastle.util.Memoable;

class SM3Digest
extends GeneralDigest {
    private static int DIGEST_LENGTH = 32;
    private static int[] v0 = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private int[] v = new int[8];
    private int[] v_ = new int[8];
    private static int[] X0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] X = new int[68];
    private int xOff;
    private int T_00_15 = 2043430169;
    private int T_16_63 = 2055708042;

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest t) {
        super((GeneralDigest)t);
        System.arraycopy(t.X, 0, this.X, 0, t.X.length);
        this.xOff = t.xOff;
        System.arraycopy(t.v, 0, this.v, 0, t.v.length);
    }

    public void reset() {
        super.reset();
        System.arraycopy(v0, 0, this.v, 0, v0.length);
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    protected void processBlock() {
        int TT2;
        int TT1;
        int SS2;
        int SS1;
        int aaa;
        int i;
        int[] ww = this.X;
        int[] ww_ = new int[64];
        for (i = 16; i < 68; ++i) {
            ww[i] = this.P1(ww[i - 16] ^ ww[i - 9] ^ this.ROTATE(ww[i - 3], 15)) ^ this.ROTATE(ww[i - 13], 7) ^ ww[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            ww_[i] = ww[i] ^ ww[i + 4];
        }
        int[] vv = this.v;
        int[] vv_ = this.v_;
        System.arraycopy(vv, 0, vv_, 0, v0.length);
        for (i = 0; i < 16; ++i) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_00_15, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_00_15(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_00_15(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
        }
        for (i = 16; i < 64; ++i) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_16_63, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_16_63(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_16_63(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
        }
        for (i = 0; i < 8; ++i) {
            int n = i;
            vv[n] = vv[n] ^ vv_[i];
        }
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)SupportClass.URShift(bitLength, 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    protected void processWord(byte[] in_Renamed, int inOff) {
        int n = in_Renamed[inOff] << 24;
        n |= (in_Renamed[++inOff] & 0xFF) << 16;
        n |= (in_Renamed[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in_Renamed[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    public int doFinal(byte[] out_Renamed, int outOff) {
        this.finish();
        for (int i = 0; i < 8; ++i) {
            SM3Digest.IntToBigEndian(this.v[i], out_Renamed, outOff + i * 4);
        }
        this.reset();
        return DIGEST_LENGTH;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return DIGEST_LENGTH;
    }

    public static void IntToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)SupportClass.URShift(n, 24);
        bs[++off] = (byte)SupportClass.URShift(n, 16);
        bs[++off] = (byte)SupportClass.URShift(n, 8);
        bs[++off] = (byte)n;
    }

    private int ROTATE(int x, int n) {
        return x << n | SupportClass.URShift(x, 32 - n);
    }

    private int P0(int X) {
        return X ^ this.ROTATE(X, 9) ^ this.ROTATE(X, 17);
    }

    private int P1(int X) {
        return X ^ this.ROTATE(X, 15) ^ this.ROTATE(X, 23);
    }

    private int FF_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int FF_16_63(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private int GG_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int GG_16_63(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    public static void main(String[] args) {
        byte[] msg1 = "abc".getBytes();
        byte[] msg2 = "abcd".getBytes();
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = Hex.byte2hex(md);
        System.out.println(s);
        for (int i = 0; i < 16; ++i) {
            sm3.update(msg2, 0, msg2.length);
        }
        sm3.doFinal(md, 0);
        String s1 = Hex.byte2hex(md);
        System.out.println(s1);
        SM3Digest sm3_ = new SM3Digest();
        sm3_.update(msg2, 0, msg2.length);
        sm3 = new SM3Digest(sm3_);
        for (int i = 1; i < 16; ++i) {
            sm3.update(msg2, 0, msg2.length);
        }
        sm3.doFinal(md, 0);
        String s2 = Hex.byte2hex(md);
        System.out.println(s2);
    }

    public Memoable copy() {
        return null;
    }

    public void reset(Memoable other) {
    }
}

