/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc.cipher;

import cn.com.syan.jcee.common.impl.asn1.ec.SM2Cipher;
import cn.com.syan.jcee.common.impl.ecc.cipher.Hex;
import cn.com.syan.jcee.common.impl.ecc.cipher.SM3Digest;
import cn.com.syan.jcee.common.impl.key.ECDomainParametersHelper;
import cn.com.syan.jcee.common.impl.security.ECKeyPairGenerator;
import cn.com.syan.jcee.utils.ByteConverter;
import java.math.BigInteger;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.encoders.Base64;

public class ECCipher {
    private int ct = 1;
    private ECPoint p2;
    private SM3Digest sm3keybase;
    private SM3Digest sm3c3;
    private byte[] key = new byte[32];
    private byte keyOff = 0;

    private void reset() {
        this.sm3keybase = new SM3Digest();
        this.sm3c3 = new SM3Digest();
        byte[] p = ByteConverter.convertTo32Bytes((BigInteger)this.p2.getX().toBigInteger());
        this.sm3keybase.update(p, 0, p.length);
        this.sm3c3.update(p, 0, p.length);
        p = ByteConverter.convertTo32Bytes((BigInteger)this.p2.getY().toBigInteger());
        this.sm3keybase.update(p, 0, p.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3keybase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public ECPoint initEncipher(ECPoint userKey) {
        BigInteger k = null;
        ECPoint c1 = null;
        AsymmetricCipherKeyPair keyPair = ECKeyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters ecPrivateKey = (ECPrivateKeyParameters)keyPair.getPrivate();
        ECPublicKeyParameters ecPublicKey = (ECPublicKeyParameters)keyPair.getPublic();
        k = ecPrivateKey.getD();
        c1 = ecPublicKey.getQ();
        this.p2 = userKey.multiply(k);
        this.reset();
        return c1;
    }

    public void encrypt(byte[] data) {
        this.sm3c3.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
    }

    public void initDecipher(BigInteger userD, ECPoint c1) {
        this.p2 = c1.multiply(userD);
        this.reset();
    }

    public void decrypt(byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        this.sm3c3.update(data, 0, data.length);
    }

    public void doFinal(byte[] c3) {
        byte[] p = ByteConverter.convertTo32Bytes((BigInteger)this.p2.getY().toBigInteger());
        this.sm3c3.update(p, 0, p.length);
        this.sm3c3.doFinal(c3, 0);
        this.reset();
    }

    public static void main(String[] args) throws Exception {
        String msg = "encryption standard";
        byte[] data = msg.getBytes();
        System.out.println("--- \u52a0\u5bc6 ----------------------------");
        String sdata = Hex.byte2hex(data);
        System.out.println("m= ");
        System.out.println(sdata);
        ECCipher cipher = new ECCipher();
        BigInteger userD = new BigInteger("1649AB77A00637BD5E2EFE283FBF353534AA7F7CB89463F208DDBC2920BB0DA0", 16);
        ECPoint userKey = ECDomainParametersHelper.getECPointG().multiply(userD);
        ECPoint c1 = cipher.initEncipher(userKey);
        byte[] bc1 = c1.getEncoded();
        System.out.println("C1=" + Hex.byte2hex(bc1));
        cipher.encrypt(data);
        byte[] c2 = data;
        String sc2 = Hex.byte2hex(data);
        System.out.println("c2= ");
        System.out.println(sc2);
        byte[] c3 = new byte[32];
        cipher.doFinal(c3);
        String sc3 = Hex.byte2hex(c3);
        System.out.println("c3= ");
        System.out.println(sc3);
        SM2Cipher sm2c = new SM2Cipher(c1.getAffineXCoord().toBigInteger(), c1.getAffineYCoord().toBigInteger(), c3, c2);
        System.out.println("sm2cipher=");
        System.out.println(new String(Base64.encode((byte[])sm2c.getEncoded())));
        System.out.println("--- \u89e3\u5bc6 ----------------------------");
        cipher = new ECCipher();
        ECPoint _c1 = ECDomainParametersHelper.getECCurve().createPoint(sm2c.getXCoordinate().getValue(), sm2c.getYCoordinate().getValue());
        cipher.initDecipher(userD, _c1);
        cipher.decrypt(data);
        System.out.println("m=" + Hex.byte2hex(data));
        byte[] _c3 = new byte[32];
        cipher.doFinal(_c3);
        String sc3_ = Hex.byte2hex(_c3);
        System.out.println("c3= ");
        System.out.println(sc3_);
    }
}

