/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.ecc;

import cn.com.syan.jcee.common.impl.ecc.sm2.SM2;
import cn.com.syan.jcee.common.impl.ecc.sm2.SM2Result;
import cn.com.syan.jcee.common.impl.ecc.sm3.SM3Digest;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.math.ec.ECPoint;

public class SM2Signature {
    private byte[] userID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private byte[] toBeVerifiedData = null;
    private SM2 sm2 = SM2.getInstance();
    private ECPublicKey publicKey;
    private ECPrivateKey privateKey;
    private SM3Digest sm3Digest = new SM3Digest();
    private boolean standardSignOperation = false;

    public final String getAlgorithm() {
        return "1.2.156.10197.1.501";
    }

    public void update(byte[] data) throws SignatureException {
        if (data == null) {
            throw new SignatureException("data cannot be null");
        }
        if (this.standardSignOperation) {
            this.sm3Digest.update(data, 0, data.length);
        } else if (this.toBeVerifiedData == null) {
            this.toBeVerifiedData = data;
        } else {
            byte[] tempData = new byte[this.toBeVerifiedData.length + data.length];
            System.arraycopy(this.toBeVerifiedData, 0, tempData, 0, this.toBeVerifiedData.length);
            System.arraycopy(data, 0, tempData, this.toBeVerifiedData.length, data.length);
            this.toBeVerifiedData = tempData;
        }
    }

    public void initSign(ECPrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("ECPrivateKey must not be null.");
        }
        this.privateKey = privateKey;
    }

    public void initSign(ECPrivateKey privateKey, ECPublicKey publicKey) {
        this.standardSignOperation = true;
        this.initSign(privateKey);
        if (publicKey == null) {
            throw new NullPointerException("ECPublicKey must not be null.");
        }
        this.publicKey = publicKey;
        this.sm3Digest.addId(publicKey.getQ().getAffineXCoord().toBigInteger(), publicKey.getQ().getAffineYCoord().toBigInteger());
    }

    public void initVerify(ECPublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        this.sm3Digest.addId(publicKey.getQ().getAffineXCoord().toBigInteger(), publicKey.getQ().getAffineYCoord().toBigInteger(), this.userID);
        this.standardSignOperation = true;
    }

    public void initVerify(Certificate certificate) throws InvalidKeyException {
        this.initVerify((ECPublicKey)certificate.getPublicKey());
    }

    public void initUserID(String userID) {
        if (userID != null) {
            this.userID = userID.getBytes();
        }
    }

    public boolean verify(byte[] signature) throws SignatureException, InvalidKeyException {
        cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature sso = cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature.getInstance(signature);
        if (!this.standardSignOperation) {
            throw new SignatureException("\u64cd\u4f5c\u6b65\u9aa4\u9519\u8bef\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u9a8c\u8bc1\u516c\u94a5\u5bf9\u8c61\uff01");
        }
        byte[] md = new byte[32];
        this.sm3Digest.doFinal(md, 0);
        SM2Result sm2Ret = new SM2Result();
        this.sm2.sm2Verify(md, this.publicKey.getQ(), sso, sm2Ret);
        return sso.getR().getValue().equals(sm2Ret.R);
    }

    public byte[] sign() throws SignatureException {
        if (!this.standardSignOperation) {
            throw new SignatureException("\u7b7e\u540d\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u7b7e\u540d\u6d41\u7a0b\u8fdb\u884c\u8c03\u7528\uff01");
        }
        byte[] signature = null;
        SM2 sm2 = SM2.getInstance();
        try {
            byte[] md = new byte[32];
            this.sm3Digest.doFinal(md, 0);
            SM2Result sm2Result = new SM2Result();
            sm2.sm2Sign(md, this.privateKey.getD(), sm2Result);
            cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature signatureObject = new cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature(sm2Result.r.toByteArray(), sm2Result.s.toByteArray());
            signature = signatureObject.toASN1Primitive().getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data");
        }
        return signature;
    }

    public byte[] sign(byte[] data, ECPublicKey publicKey) throws SignatureException {
        byte[] signature = null;
        SM2 sm2 = SM2.getInstance();
        byte[] md = this.sm3Digest(data, publicKey.getQ());
        try {
            SM2Result sm2Result = new SM2Result();
            sm2.sm2Sign(md, this.privateKey.getD(), sm2Result);
            cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature signatureObject = new cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature(sm2Result.r.toByteArray(), sm2Result.s.toByteArray());
            signature = signatureObject.toASN1Primitive().getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data");
        }
        return signature;
    }

    public byte[] sign(ECPublicKey publicKey) throws SignatureException {
        byte[] signature = null;
        SM2 sm2 = SM2.getInstance();
        try {
            if (this.toBeVerifiedData == null) {
                throw new NullPointerException();
            }
            byte[] md = this.sm3Digest(this.toBeVerifiedData, publicKey.getQ());
            SM2Result sm2Result = new SM2Result();
            sm2.sm2Sign(md, this.privateKey.getD(), sm2Result);
            cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature signatureObject = new cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature(sm2Result.r.toByteArray(), sm2Result.s.toByteArray());
            signature = signatureObject.toASN1Primitive().getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data");
        }
        return signature;
    }

    public byte[] digestSign() throws SignatureException {
        byte[] signature = null;
        SM2 sm2 = SM2.getInstance();
        try {
            if (this.toBeVerifiedData == null) {
                throw new NullPointerException();
            }
            byte[] md = this.toBeVerifiedData;
            SM2Result sm2Result = new SM2Result();
            sm2.sm2Sign(md, this.privateKey.getD(), sm2Result);
            cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature signatureObject = new cn.com.syan.jcee.common.impl.asn1.ec.SM2Signature(sm2Result.r.toByteArray(), sm2Result.s.toByteArray());
            signature = signatureObject.toASN1Primitive().getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data");
        }
        return signature;
    }

    private byte[] sm3Digest(byte[] data, ECPoint ecPointQ) {
        byte[] digest = new byte[32];
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.addId(ecPointQ.getAffineXCoord().toBigInteger(), ecPointQ.getAffineYCoord().toBigInteger(), this.userID);
        sm3Digest.update(data, 0, data.length);
        sm3Digest.doFinal(digest, 0);
        return digest;
    }
}

