/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.cert;

import cn.com.syan.jcee.common.impl.cert.CertRuntimeException;
import cn.com.syan.jcee.common.impl.utils.CertificateConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DEROutputStream;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.BasicConstraints;
import org.spongycastle.asn1.x509.Certificate;
import org.spongycastle.asn1.x509.ExtendedKeyUsage;
import org.spongycastle.asn1.x509.Extension;
import org.spongycastle.asn1.x509.ExtensionsGenerator;
import org.spongycastle.asn1.x509.KeyUsage;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.asn1.x509.TBSCertificate;
import org.spongycastle.asn1.x509.Time;
import org.spongycastle.asn1.x509.V3TBSCertificateGenerator;
import org.spongycastle.operator.ContentSigner;

public class X509V3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGenerator = new V3TBSCertificateGenerator();
    private ExtensionsGenerator extensionsGenerator;

    public X509V3CertificateBuilder(String subject, String issuer, BigInteger serial, Date notBefore, Date notAfter, SubjectPublicKeyInfo publicKeyInfo) {
        this(new X500Name(subject), new X500Name(issuer), new ASN1Integer(serial), new Time(notBefore), new Time(notAfter), publicKeyInfo);
    }

    public X509V3CertificateBuilder(X500Name subject, X500Name issuer, ASN1Integer serial, Time notBefore, Time notAfter, SubjectPublicKeyInfo publicKeyInfo) {
        this.tbsGenerator.setSerialNumber(serial);
        this.tbsGenerator.setSubject(subject);
        this.tbsGenerator.setIssuer(issuer);
        this.tbsGenerator.setStartDate(notBefore);
        this.tbsGenerator.setEndDate(notAfter);
        this.tbsGenerator.setSubjectPublicKeyInfo(publicKeyInfo);
        this.extensionsGenerator = new ExtensionsGenerator();
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, byte[] encodedValue) {
        this.extensionsGenerator.addExtension(oid, isCritical, encodedValue);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws IOException {
        this.extensionsGenerator.addExtension(oid, isCritical, value);
    }

    public void addExtensions(Vector oids, Vector values) throws IOException {
        for (int i = 0; i != oids.size(); ++i) {
            Extension ext = (Extension)values.elementAt(i);
            this.extensionsGenerator.addExtension((ASN1ObjectIdentifier)oids.elementAt(i), ext.isCritical(), ext.getParsedValue());
        }
    }

    public void addBasicConstraints(boolean isCritical, BasicConstraints basicConstraints) throws IOException {
        this.extensionsGenerator.addExtension(Extension.basicConstraints, isCritical, (ASN1Encodable)basicConstraints);
    }

    public void addSubjectKeyIdentifier(byte[] subjectKeyID) {
        this.extensionsGenerator.addExtension(Extension.subjectKeyIdentifier, false, subjectKeyID);
    }

    public void addSubjectKeyIdentifier(ASN1Encodable subjectKeyID) throws IOException {
        this.extensionsGenerator.addExtension(Extension.subjectKeyIdentifier, false, subjectKeyID);
    }

    public void addAuthorityKeyIdentifier(ASN1Encodable authorityKeyID) throws IOException {
        this.extensionsGenerator.addExtension(Extension.authorityKeyIdentifier, false, authorityKeyID);
    }

    public void addAuthorityKeyIdentifier(byte[] authorityKeyID) {
        this.extensionsGenerator.addExtension(Extension.authorityKeyIdentifier, false, authorityKeyID);
    }

    public void addKeyUsage(boolean isCritical, KeyUsage keyUsage) throws IOException {
        this.extensionsGenerator.addExtension(Extension.keyUsage, isCritical, (ASN1Encodable)keyUsage);
    }

    public void addExtendedKeyUsage(boolean isCritical, ExtendedKeyUsage extendedKeyUsage) throws IOException {
        this.extensionsGenerator.addExtension(Extension.extendedKeyUsage, isCritical, (ASN1Encodable)extendedKeyUsage);
    }

    public X509Certificate build(ContentSigner signer) throws IOException {
        this.tbsGenerator.setSignature(signer.getAlgorithmIdentifier());
        if (!this.extensionsGenerator.isEmpty()) {
            this.tbsGenerator.setExtensions(this.extensionsGenerator.generate());
        }
        TBSCertificate tbsCertificate = this.tbsGenerator.generateTBSCertificate();
        OutputStream outputStream = signer.getOutputStream();
        DEROutputStream derOutputStream = new DEROutputStream(outputStream);
        derOutputStream.writeObject((ASN1Encodable)tbsCertificate);
        outputStream.close();
        byte[] signature = signer.getSignature();
        Certificate certificate = X509V3CertificateBuilder.generateStructure(tbsCertificate, signer.getAlgorithmIdentifier(), signature);
        try {
            return CertificateConverter.fromBinary(certificate.getEncoded());
        }
        catch (CertificateException e) {
            throw new CertRuntimeException(e.getMessage(), e);
        }
    }

    private static Certificate generateStructure(TBSCertificate tbsCert, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)sigAlgId);
        v.add((ASN1Encodable)new DERBitString(signature));
        return Certificate.getInstance((Object)new DERSequence(v));
    }
}

