/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.chaincert;

import java.io.IOException;
import org.spongycastle.asn1.ASN1Boolean;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;

public class SubjectKeyIdentifier
extends ASN1Object {
    private static final String id_ce = "2.5.29.14";
    private ASN1ObjectIdentifier id_ce_subjectKeyIdentifier = new ASN1ObjectIdentifier("2.5.29.14");
    private DEROctetString subject;
    private ASN1Boolean isTrue;

    public SubjectKeyIdentifier(byte[] subject) {
        this.subject = new DEROctetString(subject);
        this.isTrue = ASN1Boolean.TRUE;
    }

    public SubjectKeyIdentifier(byte[] subject, boolean trueOrFalse) {
        this.subject = new DEROctetString(subject);
        this.isTrue = new ASN1Boolean(trueOrFalse);
    }

    private SubjectKeyIdentifier(ASN1Sequence sequence) {
        this.id_ce_subjectKeyIdentifier = ASN1ObjectIdentifier.getInstance((Object)sequence.getObjectAt(0));
        this.subject = (DEROctetString)DEROctetString.getInstance((Object)sequence.getObjectAt(sequence.size() - 1));
    }

    public static SubjectKeyIdentifier getInstance(Object object) throws IOException {
        SubjectKeyIdentifier instance = null;
        if (object instanceof SubjectKeyIdentifier) {
            instance = (SubjectKeyIdentifier)((Object)object);
        } else if (object instanceof ASN1Sequence) {
            instance = new SubjectKeyIdentifier(ASN1Sequence.getInstance((Object)object));
        } else if (object instanceof byte[]) {
            instance = new SubjectKeyIdentifier(ASN1Sequence.getInstance((Object)ASN1Sequence.fromByteArray((byte[])((byte[])object))));
        }
        return instance;
    }

    public ASN1ObjectIdentifier getId_ce_subjectKeyIdentifier() {
        return this.id_ce_subjectKeyIdentifier;
    }

    public DEROctetString getSubject() {
        return this.subject;
    }

    public void setId_ce_subjectKeyIdentifier(ASN1ObjectIdentifier id_ce_subjectKeyIdentifier) {
        this.id_ce_subjectKeyIdentifier = id_ce_subjectKeyIdentifier;
    }

    public void setSubject(DEROctetString subject) {
        this.subject = subject;
    }

    public ASN1Boolean getIsTrue() {
        return this.isTrue;
    }

    public void setIsTrue(ASN1Boolean isTrue) {
        this.isTrue = isTrue;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.id_ce_subjectKeyIdentifier);
        if (this.isTrue != null) {
            v.add((ASN1Encodable)this.isTrue);
        }
        v.add((ASN1Encodable)this.subject);
        return new DERSequence(v);
    }
}

