/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.chaincert;

import cn.com.syan.jcee.common.impl.asn1.chaincert.AuthorizedIdentifyCode;
import cn.com.syan.jcee.common.impl.asn1.chaincert.SubjectKeyIdentifier;
import cn.com.syan.jcee.utils.StringConverter;
import cn.com.syan.jcee.utils.codec.binary.Base64;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DERUTF8String;

public class PrivilegeInfoContent
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(1L);
    private DERUTF8String authorizedCommonName;
    private AuthorizedIdentifyCode authorizedIdentifyCode;
    private SubjectKeyIdentifier subjectKeyIdentifier;
    private ASN1Sequence privilegeExtensions;

    private PrivilegeInfoContent(String authorizedCommonName, Map<String, Object> authorizedIdentifyCode, byte[] subjectKeyIdentifie, Date notBefore, Date notAfter, String[] extKeyUsages) {
        this.authorizedCommonName = new DERUTF8String(authorizedCommonName);
        this.authorizedIdentifyCode = new AuthorizedIdentifyCode(authorizedIdentifyCode);
        this.subjectKeyIdentifier = new SubjectKeyIdentifier(subjectKeyIdentifie);
    }

    public PrivilegeInfoContent(String authorizedCommonName, Map<String, Object> authorizedIdentifyCode, byte[] subjectKeyIdentifie) {
        this.authorizedCommonName = new DERUTF8String(authorizedCommonName);
        this.authorizedIdentifyCode = new AuthorizedIdentifyCode(authorizedIdentifyCode);
        this.subjectKeyIdentifier = new SubjectKeyIdentifier(subjectKeyIdentifie);
    }

    private PrivilegeInfoContent(ASN1Sequence sequence) throws IOException {
        this.authorizedCommonName = DERUTF8String.getInstance((Object)sequence.getObjectAt(1));
        this.authorizedIdentifyCode = AuthorizedIdentifyCode.getInstance(sequence.getObjectAt(2));
        this.subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(sequence.getObjectAt(3));
        if (sequence.size() > 4) {
            this.privilegeExtensions = ASN1Sequence.getInstance((Object)sequence.getObjectAt(4));
        }
    }

    public void setPrivilegeExtensions(ASN1Sequence privilegeExtensions) {
        this.privilegeExtensions = privilegeExtensions;
    }

    public static PrivilegeInfoContent getInstance(Object object) throws IOException {
        PrivilegeInfoContent instance = null;
        if (object instanceof PrivilegeInfoContent) {
            instance = (PrivilegeInfoContent)((Object)object);
        } else if (object instanceof ASN1Sequence) {
            instance = new PrivilegeInfoContent(ASN1Sequence.getInstance((Object)object));
        } else if (object instanceof byte[]) {
            instance = new PrivilegeInfoContent(ASN1Sequence.getInstance((Object)ASN1Sequence.fromByteArray((byte[])((byte[])object))));
        }
        return instance;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.authorizedCommonName);
        v.add((ASN1Encodable)this.authorizedIdentifyCode);
        v.add((ASN1Encodable)this.subjectKeyIdentifier);
        this.addOptional(v, 0, (ASN1Encodable)this.privilegeExtensions);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, tagNo, obj));
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public DERUTF8String getAuthorizedCommonName() {
        return this.authorizedCommonName;
    }

    public AuthorizedIdentifyCode getAuthorizedIdentifyCode() {
        return this.authorizedIdentifyCode;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public ASN1Sequence getPrivilegeExtensions() {
        return this.privilegeExtensions;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public void setAuthorizedCommonName(DERUTF8String authorizedCommonName) {
        this.authorizedCommonName = authorizedCommonName;
    }

    public void setAuthorizedIdentifyCode(AuthorizedIdentifyCode authorizedIdentifyCode) {
        this.authorizedIdentifyCode = authorizedIdentifyCode;
    }

    public void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public static void main(String[] args) throws Exception {
        String authorizedCommonName = "\u5362\u4e49\u601d";
        String authorizedIdentifyCode = "\u89e3\u653e\u519b";
        HashMap<String, String> identMap = new HashMap<String, String>();
        identMap.put("tag", "1");
        identMap.put("value", authorizedIdentifyCode);
        HashMap<String, Object> authMap = new HashMap<String, Object>();
        authMap.put("tag", "1");
        authMap.put("value", identMap);
        String hexStr = "3FFB603061AB979C7F8225382FD06730E85F80BC22C1014E39A529D0CB1779BB";
        byte[] subjectKeyIdentifie = StringConverter.toBinary((String)hexStr);
        Date notBefore = new Date();
        Date notAfter = new Date();
        String[] extKeyUsages = new String[]{"1.2.156.112620.2.1.2.9.30.4.1", "1.2.156.112620.2.1.2.9.30.4.2"};
        PrivilegeInfoContent content = new PrivilegeInfoContent(authorizedCommonName, authMap, subjectKeyIdentifie, notBefore, notAfter, extKeyUsages);
        content.setPrivilegeExtensions(ASN1Sequence.getInstance((Object)((Object)content.getSubjectKeyIdentifier())));
        byte[] asn1date = content.getEncoded();
        System.out.print(Base64.encodeBase64String((byte[])asn1date));
        String localcert = "MIIBrDCCAVGgAwIBAgIJANjT+13BZV7vMAoGCCqBHM9VAYN1MDIxCzAJBgNVBAYT\nAkNOMQ0wCwYDVQQKDARTWUFOMRQwEgYDVQQDDAtwY3Nfc3ZzX3NtMjAeFw0xOTA0\nMDkwNjQzMzRaFw0yOTA0MDYwNjQzMzRaMDIxCzAJBgNVBAYTAkNOMQ0wCwYDVQQK\nDARTWUFOMRQwEgYDVQQDDAtwY3Nfc3ZzX3NtMjBZMBMGByqGSM49AgEGCCqBHM9V\nAYItA0IABGZLwIC/GTMJJCs6g4puNwvQQhr5gp3iex+rH0NOz4dGrPgp+9ShqEjK\nfL2oLjvk88UK9az17C3hoin8m3si7W6jUDBOMB0GA1UdDgQWBBRgxCQn/77lhQWR\nKWFXYXnEFATLNzAfBgNVHSMEGDAWgBRgxCQn/77lhQWRKWFXYXnEFATLNzAMBgNV\nHRMEBTADAQH/MAoGCCqBHM9VAYN1A0kAMEYCIQDzZEX79jq0LNhNF8SgrciSv+LV\nX9oYSv47pxobc9jU9AIhAN/XsY2Avva6FKmS8xOjC2rQRdIGEEoDYKkOZygHEVQv\n";
    }
}

