/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1.chaincert;

import cn.com.syan.jcee.common.impl.asn1.chaincert.IdentifyCode;
import java.io.IOException;
import java.util.Map;
import org.spongycastle.asn1.ASN1Choice;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERTaggedObject;

public class AuthorizedIdentifyCode
extends ASN1Object
implements ASN1Choice {
    private DERPrintableString iCregistrationNumber;
    private IdentifyCode identifyCode;
    private int tagValue;

    public AuthorizedIdentifyCode(Map<String, Object> identifyCode) {
        int authorizedTag = Integer.valueOf((String)identifyCode.get("tag"));
        Object o = identifyCode.get("value");
        if (authorizedTag == 0 && o instanceof String) {
            this.tagValue = 0;
            this.iCregistrationNumber = new DERPrintableString((String)o);
        } else if (authorizedTag == 1 && o instanceof Map) {
            this.tagValue = 1;
            Map map = (Map)o;
            int identifyTag = Integer.valueOf((String)map.get("tag"));
            String codeString = (String)map.get("value");
            this.identifyCode = new IdentifyCode(identifyTag, codeString);
        } else {
            throw new IllegalArgumentException("Invalid object: " + identifyCode.getClass().getName());
        }
    }

    public AuthorizedIdentifyCode(DERPrintableString iCregistrationNumber) {
        this.tagValue = 0;
        this.iCregistrationNumber = iCregistrationNumber;
    }

    public AuthorizedIdentifyCode(IdentifyCode identifyCode) {
        this.tagValue = 1;
        this.identifyCode = identifyCode;
    }

    public static AuthorizedIdentifyCode getInstance(Object o) {
        if (o != null && !(o instanceof AuthorizedIdentifyCode)) {
            if (o instanceof byte[]) {
                try {
                    o = ASN1Primitive.fromByteArray((byte[])((byte[])o));
                }
                catch (IOException var2) {
                    throw new IllegalArgumentException("Invalid encoding in AuthorizedIdentifyCode");
                }
            }
            if (o instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)o;
                if (((ASN1TaggedObject)o).getTagNo() == 0) {
                    return new AuthorizedIdentifyCode(DERPrintableString.getInstance((ASN1TaggedObject)taggedObject, (boolean)true));
                }
                return new AuthorizedIdentifyCode(IdentifyCode.getInstance(taggedObject.getObject()));
            }
            if (o instanceof DERPrintableString) {
                return new AuthorizedIdentifyCode((DERPrintableString)o);
            }
            throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
        }
        return (AuthorizedIdentifyCode)((Object)o);
    }

    public DERPrintableString getiCregistrationNumber() {
        return this.iCregistrationNumber;
    }

    public IdentifyCode getIdentifyCode() {
        return this.identifyCode;
    }

    public int getTagValue() {
        return this.tagValue;
    }

    public void setiCregistrationNumber(DERPrintableString iCregistrationNumber) {
        this.iCregistrationNumber = iCregistrationNumber;
    }

    public void setIdentifyCode(IdentifyCode identifyCode) {
        this.identifyCode = identifyCode;
    }

    public void setTagValue(int tagValue) {
        this.tagValue = tagValue;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.iCregistrationNumber != null ? new DERTaggedObject(true, 0, (ASN1Encodable)this.iCregistrationNumber) : new DERTaggedObject(true, 1, (ASN1Encodable)this.identifyCode);
    }
}

