/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1;

import cn.com.syan.jcee.common.impl.asn1.SM2BCPrivateKeyStructure;
import cn.com.syan.jcee.common.impl.identifier.SparkAlgorithmIdentifier;
import cn.com.syan.jcee.common.impl.key.SM2BCPublicKey;
import cn.com.syan.jcee.common.impl.key.SparkECPrivateKey;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERBitString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class SM2BCPrivateKey
extends ASN1Object {
    private BigInteger version;
    private AlgorithmIdentifier algorithm;
    private ASN1OctetString value;

    public SM2BCPrivateKey(BCECPrivateKey privateKey, BCECPublicKey publicKey) throws IOException {
        SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(publicKey.getQ());
        this.version = BigInteger.valueOf(0L);
        this.algorithm = SparkAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM;
        DEROctetString d = new DEROctetString(privateKey.getD().toByteArray());
        DERTaggedObject g = new DERTaggedObject(true, 1, (ASN1Encodable)new DERBitString(sm2BCPublicKey.getEncoded()));
        SM2BCPrivateKeyStructure pkStructure = new SM2BCPrivateKeyStructure(d, g);
        this.value = new DEROctetString(pkStructure.getEncoded());
    }

    public SM2BCPrivateKey(SparkECPrivateKey sparkECPrivateKey) throws IOException {
        this(sparkECPrivateKey.getECPrivateKey(), sparkECPrivateKey.getECPublicKey());
    }

    public SM2BCPrivateKey(AlgorithmIdentifier algorithmIdentifier, DEROctetString value) {
        this.version = BigInteger.valueOf(0L);
        this.algorithm = algorithmIdentifier;
        this.value = value;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    private SM2BCPrivateKey(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        BigInteger v = ((ASN1Integer)e.nextElement()).getValue();
        if (v.intValue() != 0 && v.intValue() != 1) {
            throw new IllegalArgumentException("wrong version for SM2 private key");
        }
        this.version = v;
        this.algorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        this.value = DEROctetString.getInstance(e.nextElement());
    }

    public static SM2BCPrivateKey getInstance(Object obj) {
        if (obj instanceof ASN1Sequence) {
            return new SM2BCPrivateKey((ASN1Sequence)obj);
        }
        ASN1Primitive primitive = ((ASN1Encodable)obj).toASN1Primitive();
        if (primitive instanceof ASN1Sequence) {
            return new SM2BCPrivateKey((ASN1Sequence)primitive);
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(this.version));
        v.add((ASN1Encodable)this.algorithm);
        v.add((ASN1Encodable)this.value);
        return new DERSequence(v);
    }
}

