/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.impl.asn1;

import cn.com.syan.jcee.common.impl.asn1.ECParameters;
import cn.com.syan.jcee.utils.StringFormatHelper;
import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.util.encoders.Base64;

public class ECPrivateKey
extends ASN1Object {
    private ASN1Integer version;
    private DEROctetString privateKey;
    private ECParameters parameters;
    private DEROctetString publicKey;

    public ECPrivateKey(BigInteger privateKey, ASN1ObjectIdentifier namedCurve) {
        this.version = new ASN1Integer(1L);
        this.privateKey = new DEROctetString(privateKey.toByteArray());
        this.parameters = new ECParameters(namedCurve);
    }

    public ECPrivateKey(BigInteger version, byte[] privateKey, ASN1ObjectIdentifier namedCurve) {
        this.version = new ASN1Integer(version);
        this.privateKey = new DEROctetString(privateKey);
        this.parameters = new ECParameters(namedCurve);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.privateKey);
        this.addOptional(v, 0, (ASN1Encodable)this.parameters);
        this.addOptional(v, 1, (ASN1Encodable)this.publicKey);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, tagNo, obj));
        }
    }

    public static void main(String[] ars) throws IOException {
        String privateKey = "eeaf527f7c2fee6ac4b5302335109fc7c135de088761059a8ad761f6f2104757";
        BigInteger bi = new BigInteger(privateKey, 16);
        ASN1ObjectIdentifier ec = new ASN1ObjectIdentifier("1.2.156.10197.1.301");
        ECPrivateKey ek = new ECPrivateKey(bi, ec);
        String xx = new String(Base64.encode((byte[])ek.getEncoded()));
        System.out.println(StringFormatHelper.toPEMString((String)xx, (int)5));
    }
}

