/*
 * Decompiled with CFR 0.152.
 */
package com.catsic.system.sm.util;

import cn.hutool.core.util.StrUtil;
import com.catsic.system.sm.util.KeyPairOfString;
import com.catsic.system.sm.util.SM2EngineExtend;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class SMCryptoUtilNew {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";
    public static final String SIGN_ID = "1234567812345678";

    public static KeyPairOfString getSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        try {
            keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, SecureRandom.getInstance("SHA1PRNG")));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.print("\u751f\u6210\u516c\u79c1\u94a5\u5bf9\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed));
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16);
        System.out.print("\npublicKey\uff1a" + publicKey + "\nprivateKey\uff1a" + privateKey);
        return new KeyPairOfString(publicKey, privateKey);
    }

    public static String encrypt(String publicKey, String data) {
        return SMCryptoUtilNew.encrypt(publicKey, data, SM2EngineExtend.CIPHERMODE_NORM);
    }

    public static String encrypt(String publicKey, String data, int cipherMode) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2EngineExtend sm2Engine = new SM2EngineExtend();
        sm2Engine.init(true, cipherMode, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = StrUtil.utf8Bytes((CharSequence)data);
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        }
        catch (Exception e) {
            System.out.print("SM2\u52a0\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return Hex.toHexString((byte[])arrayOfBytes);
    }

    public static String decrypt(String privateKey, String cipherData) {
        return SMCryptoUtilNew.decrypt(privateKey, cipherData, SM2EngineExtend.CIPHERMODE_NORM);
    }

    public static String decrypt(String privateKey, String cipherData, int cipherMode) {
        if (!cipherData.startsWith("04")) {
            cipherData = "04" + cipherData;
        }
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2EngineExtend sm2Engine = new SM2EngineExtend();
        sm2Engine.init(false, cipherMode, (CipherParameters)privateKeyParameters);
        String result = "";
        try {
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            result = StrUtil.utf8Str((Object)arrayOfBytes);
        }
        catch (Exception e) {
            System.out.print("SM2\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return result;
    }

    public static String sign_Sm2(String privateKey, String content) throws CryptoException {
        byte[] message = StrUtil.utf8Bytes((CharSequence)content);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Signer sm2Signer = new SM2Signer();
        try {
            sm2Signer.init(true, (CipherParameters)new ParametersWithID((CipherParameters)new ParametersWithRandom((CipherParameters)privateKeyParameters, SecureRandom.getInstance("SHA1PRNG")), Strings.toByteArray((String)SIGN_ID)));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.print("\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        sm2Signer.update(message, 0, message.length);
        byte[] signBytes = sm2Signer.generateSignature();
        String sign = Hex.toHexString((byte[])signBytes);
        return sign;
    }

    public static boolean verify_Sm2(String publicKey, String content, String sign) {
        byte[] message = StrUtil.utf8Bytes((CharSequence)content);
        byte[] signData = Hex.decode((String)sign);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Signer sm2Signer = new SM2Signer();
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)publicKeyParameters, Strings.toByteArray((String)SIGN_ID));
        sm2Signer.init(false, (CipherParameters)parametersWithID);
        sm2Signer.update(message, 0, message.length);
        boolean verify = sm2Signer.verifySignature(signData);
        return verify;
    }
}

