/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.serializer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AssocArray
implements Cloneable,
Serializable {
    private ArrayList arrayList;
    private LinkedHashMap hashMap;
    private int arrayLength;
    private int maxNumber;

    public AssocArray() {
        this.arrayList = new ArrayList();
        this.hashMap = new LinkedHashMap();
        this.arrayLength = 0;
        this.maxNumber = -1;
    }

    public AssocArray(int initialCapacity) {
        this.arrayList = new ArrayList(initialCapacity);
        this.hashMap = new LinkedHashMap(initialCapacity);
        this.arrayLength = 0;
        this.maxNumber = -1;
    }

    public AssocArray(int initialCapacity, float loadFactor) {
        this.arrayList = new ArrayList(initialCapacity);
        this.hashMap = new LinkedHashMap(initialCapacity, loadFactor);
        this.arrayLength = 0;
        this.maxNumber = -1;
    }

    public AssocArray(Collection c) {
        this.arrayList = new ArrayList(c);
        this.arrayLength = this.arrayList.size();
        this.maxNumber = this.arrayLength - 1;
        this.hashMap = new LinkedHashMap(this.arrayLength);
        int i = 0;
        while (i < this.arrayLength) {
            this.hashMap.put(new Integer(i), this.arrayList.get(i));
            ++i;
        }
    }

    public AssocArray(Map m) {
        int len = m.size();
        this.arrayList = new ArrayList(len);
        this.hashMap = new LinkedHashMap(len);
        this.arrayLength = 0;
        this.maxNumber = -1;
        for (Object key : m.keySet()) {
            if (key instanceof Integer || key instanceof Short || key instanceof Byte) {
                int k = ((Number)key).intValue();
                if (k > -1) {
                    ++this.arrayLength;
                    if (this.maxNumber < k) {
                        this.maxNumber = k;
                    }
                }
                this.hashMap.put(new Integer(k), m.get(key));
                continue;
            }
            if (!(key instanceof String)) continue;
            this.hashMap.put(key, m.get(key));
        }
        this.setArrayList();
    }

    private void setArrayList() {
        block4: {
            int len = this.arrayList.size();
            if (len >= this.arrayLength) break block4;
            if (this.maxNumber + 1 == this.arrayLength) {
                int i = len;
                while (i < this.arrayLength) {
                    this.arrayList.add(this.hashMap.get(new Integer(i)));
                    ++i;
                }
            } else {
                Integer key = new Integer(len);
                while (this.hashMap.containsKey(key)) {
                    this.arrayList.add(this.hashMap.get(key));
                    key = new Integer(++len);
                }
            }
        }
    }

    public ArrayList toArrayList() {
        this.setArrayList();
        return this.arrayList;
    }

    public HashMap toHashMap() {
        return this.hashMap;
    }

    public LinkedHashMap toLinkedHashMap() {
        return this.hashMap;
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    public boolean add(Object element) {
        int index = this.arrayList.size();
        boolean result = this.arrayList.add(element);
        if (result) {
            Integer key = new Integer(index);
            if (!this.hashMap.containsKey(key)) {
                ++this.arrayLength;
                if (this.maxNumber < index) {
                    this.maxNumber = index;
                }
            }
            this.hashMap.put(key, element);
        }
        return result;
    }

    public boolean addAll(Collection c) {
        int len = c.size();
        int index = this.arrayList.size() - 1;
        boolean result = this.arrayList.addAll(c);
        if (result) {
            int i = 0;
            while (i < len) {
                Integer key;
                if (!this.hashMap.containsKey(key = new Integer(++index))) {
                    ++this.arrayLength;
                }
                this.hashMap.put(key, this.arrayList.get(index));
                ++i;
            }
            if (this.maxNumber < index) {
                this.maxNumber = index;
            }
        }
        return result;
    }

    public void putAll(Map m) {
        for (Object key : m.keySet()) {
            if (key instanceof Integer || key instanceof Short || key instanceof Byte) {
                int k = ((Number)key).intValue();
                key = new Integer(k);
                if (k > -1 && !this.hashMap.containsKey(key)) {
                    ++this.arrayLength;
                    if (this.maxNumber < k) {
                        this.maxNumber = k;
                    }
                }
                this.hashMap.put(key, m.get(key));
                continue;
            }
            if (!(key instanceof String)) continue;
            this.hashMap.put(key, m.get(key));
        }
        this.setArrayList();
    }

    public Object get(int index) {
        if (index < this.arrayList.size()) {
            return this.arrayList.get(index);
        }
        return this.hashMap.get(new Integer(index));
    }

    public Object get(Byte key) {
        return this.get(key.intValue());
    }

    public Object get(Short key) {
        return this.get(key.intValue());
    }

    public Object get(Integer key) {
        return this.get((int)key);
    }

    public Object get(String key) {
        return this.hashMap.get(key);
    }

    public Object set(int index, Object element) {
        Integer key = new Integer(index);
        if (index > -1) {
            int size = this.arrayList.size();
            if (size > index) {
                this.arrayList.set(index, element);
            } else {
                if (size == index) {
                    this.arrayList.add(element);
                }
                if (!this.hashMap.containsKey(key)) {
                    ++this.arrayLength;
                    if (this.maxNumber < index) {
                        this.maxNumber = index;
                    }
                }
            }
        }
        return this.hashMap.put(key, element);
    }

    public Object set(Byte key, Object element) {
        return this.set(key.intValue(), element);
    }

    public Object set(Short key, Object element) {
        return this.set(key.intValue(), element);
    }

    public Object set(Integer key, Object element) {
        return this.set((int)key, element);
    }

    public Object set(String key, Object element) {
        return this.hashMap.put(key, element);
    }

    public Object remove(int index) {
        Integer key = new Integer(index);
        if (index > -1) {
            if (this.hashMap.containsKey(key)) {
                --this.arrayLength;
                int lastIndex = this.arrayList.size() - 1;
                if (index <= lastIndex) {
                    int i = lastIndex;
                    while (i >= index) {
                        this.arrayList.remove(i);
                        --i;
                    }
                    if (this.maxNumber == index) {
                        --this.maxNumber;
                    }
                } else if (this.maxNumber == index) {
                    while (--index > lastIndex && !this.hashMap.containsKey(new Integer(index))) {
                    }
                    this.maxNumber = index;
                }
            } else {
                return null;
            }
        }
        return this.hashMap.remove(key);
    }

    public Object remove(Byte key) {
        return this.remove(key.intValue());
    }

    public Object remove(Short key) {
        return this.remove(key.intValue());
    }

    public Object remove(Integer key) {
        return this.remove((int)key);
    }

    public Object remove(String key) {
        return this.hashMap.remove(key);
    }

    public void clear() {
        this.arrayList.clear();
        this.hashMap.clear();
        this.arrayLength = 0;
        this.maxNumber = -1;
    }

    public Object clone() throws CloneNotSupportedException {
        AssocArray result = null;
        result = (AssocArray)super.clone();
        result.arrayList = (ArrayList)this.arrayList.clone();
        result.hashMap = (LinkedHashMap)this.hashMap.clone();
        result.arrayLength = this.arrayLength;
        result.maxNumber = this.maxNumber;
        return result;
    }
}

