/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.security;

import cn.trust.sign.client.exceptions.SVSConnectException;
import cn.trust.sign.client.security.SecurityEngine;
import cn.trust.sign.client.security.SignService;
import cn.trust.sign.model.TrustSignInfo;
import com.dovtrust.client.exceptions.ParameterInvalidException;
import com.dovtrust.client.exceptions.ParameterOutRangeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.json.simple.parser.ParseException;

public class SignServiceImpl
extends SignService {
    private SecurityEngine safeEng = null;

    public SignServiceImpl() {
        this.safeEng = new SecurityEngine();
    }

    public SignServiceImpl(String appName) {
        this.safeEng = new SecurityEngine(appName);
    }

    @Override
    public boolean finalizeEngine() {
        return this.safeEng.finalizeEngine();
    }

    @Override
    public int pdfSignLTPEvent(String eventContent, String eventType) {
        int result = -1;
        try {
            result = this.safeEng.pdfSignLTPEvent(eventContent, eventType);
        }
        catch (ParameterInvalidException e) {
            e.printStackTrace();
        }
        catch (SVSConnectException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public byte[] verifyPDF(byte[] inFileName, int[] rv) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException {
        return this.safeEng.verifyPDF(inFileName, rv);
    }

    @Override
    public String verifyPDF(String inFileName, int[] rv) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException {
        return this.safeEng.verifyPDF(inFileName, rv);
    }

    @Override
    public byte[] unitSignByRule(String templateNo, byte[] PDFBytes, String snapshotJson, int[] rv) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException {
        return this.safeEng.signPDFWithUnit(templateNo, PDFBytes, snapshotJson, rv);
    }

    @Override
    public byte[] unitSignByRule(String RuleNo, byte[] PDFBytes, String snapshot, String base64Cert, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, IOException, Exception {
        return this.safeEng.signPDFWithUnit(RuleNo, PDFBytes, base64Cert, snapshot, rv);
    }

    @Override
    public String unitSignByXYZ(String jsonBean) throws ParseException, ParameterInvalidException, ParameterOutRangeException, SVSConnectException, Exception {
        return this.safeEng.unitSignEncByXYZ(jsonBean);
    }

    @Override
    public byte[] unitSignByXYZ(byte[] pdfBytes, byte[] imageBytes, String jsonBean, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        return this.safeEng.unitSignByXYZ(pdfBytes, imageBytes, jsonBean, rv);
    }

    @Override
    public String unitSignByKW(String jsonBean) throws ParameterInvalidException, ParseException, ParameterOutRangeException, SVSConnectException, Exception {
        return this.safeEng.signEncWithKW(jsonBean);
    }

    @Override
    public byte[] unitSignByKW(byte[] pdfBytes, byte[] imageBytes, String jsonBean, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signWithKW(pdfBytes, imageBytes, jsonBean, rv);
    }

    @Override
    public byte[] signPdfXYZByPrikey(byte[] pdf, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.signPdfXYZByPrikey(pdf, imageBytes, jsonUserInfo, jsonSignInfo, rv);
    }

    @Override
    public String textToImg(String jsonBean) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        return this.safeEng.textToImg(jsonBean);
    }

    @Override
    public List<byte[]> signPDF(TrustSignInfo trustSignInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException {
        return this.safeEng.signPDFWithEnc(trustSignInfo, rv);
    }

    @Override
    public String hashSign(String hash, String base64Cert, int[] rv) throws SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.hashSign(hash, base64Cert, rv);
    }

    @Override
    public String signData(byte[] signData, int plainData, int certContent, int tsCertContent, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signData(signData, plainData, certContent, tsCertContent, rv);
    }

    @Override
    public byte[] verifySign(byte[] signValue, String originalData, int type, int[] rv) throws SVSConnectException, UnsupportedEncodingException, ParameterInvalidException {
        return this.safeEng.verifySign(signValue, originalData, type, rv);
    }

    @Override
    public List<String> genP10(String certAlg, int pubKeyLength, String userName, String pwd, int[] rv) throws ParameterInvalidException, SVSConnectException, Exception {
        return this.safeEng.genP10(certAlg, pubKeyLength, userName, pwd, rv);
    }

    @Override
    public String genCertByP10(String certAlg, String p10, String appKey, String certOID, int[] rv) throws ParameterInvalidException, SVSConnectException, IOException {
        return this.safeEng.genCertByP10(certAlg, p10, appKey, certOID, rv);
    }

    @Override
    public byte[] signPdf(byte[] pdf, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, NumberFormatException, UnsupportedEncodingException {
        return this.safeEng.signPdf(pdf, imageBytes, jsonUserInfo, jsonSignInfo, rv);
    }

    @Override
    public byte[] htmlToPdf(byte[] htmlBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.htmlToPdf(htmlBytes, rv);
    }

    @Override
    public byte[] wordToPdf(byte[] htmlBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.wordToPdf(htmlBytes, rv);
    }

    @Override
    public String packSignData(String originalData, String channel, List<String> UserSigns) throws ParameterInvalidException, ParseException, IOException {
        return this.safeEng.packSignData(originalData, channel, UserSigns);
    }

    @Override
    public String saveEvidence(byte[] inData, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, Exception {
        return this.safeEng.saveEvidence(inData, rv);
    }

    @Override
    public String queryEvidence(String txId, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException {
        return this.safeEng.queryEvidence(txId, rv);
    }

    @Override
    public String signDataByPrikey(String signInfoJson, String jsonUserInfo, int plainData, int certContent, int tsCertContent, int[] rv) throws UnsupportedEncodingException, ParameterInvalidException, ParseException, SVSConnectException {
        return this.safeEng.signDataByPrikey(signInfoJson, jsonUserInfo, plainData, certContent, tsCertContent, rv);
    }

    @Override
    public String simpleSignDataByPrikey(String signInfoJson, String jsonUserInfo, int[] rv) throws UnsupportedEncodingException, ParameterInvalidException, ParseException, SVSConnectException {
        return this.safeEng.simpleSignDataByPrikey(signInfoJson, jsonUserInfo, rv);
    }

    @Override
    public String updatePrikeyByPwd(String oldPwd, String oldPrikey, String newPwd, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException {
        return this.safeEng.updatePrikeyByPwd(oldPwd, oldPrikey, newPwd, rv);
    }

    @Override
    public String getSignOriginal(byte[] pdfBytes, byte[] imageBytes, String jsonSignInfo, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        return this.safeEng.getSignOriginal(pdfBytes, imageBytes, jsonSignInfo, rv);
    }

    @Override
    public String signDataHash(byte[] signData, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signDataHash(signData, rv);
    }

    @Override
    public String signDataHashP7(byte[] signData, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signDataHashP7(signData, rv);
    }

    @Override
    public String signDataHashP1(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signDataHashP1(signInfoJson, jsonUserInfo, rv);
    }

    @Override
    public String signDataHashP7(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signDataHashP7(signInfoJson, jsonUserInfo, rv);
    }

    @Override
    public String signDataHashP7WithUserInfo(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        return this.safeEng.signDataHashP7WithUserInfo(signInfoJson, jsonUserInfo, rv);
    }

    @Override
    public byte[] pdfToImage(byte[] pdfBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.pdfToImage(pdfBytes, rv);
    }

    @Override
    public byte[] signPdfWithAnnotation(byte[] pdf, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, UnsupportedEncodingException {
        return this.safeEng.signPdfWithAnnotation(pdf, imageBytes, jsonUserInfo, jsonSignInfo, rv);
    }

    @Override
    public byte[] mergeP1SignValueToPdf(String signOriginalBase64, byte[] p7derAttrs, int[] byteRange, byte[] p1SignValue, String signCert, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        return this.safeEng.mergeP1SignValueToPdf(signOriginalBase64, p7derAttrs, byteRange, p1SignValue, signCert, rv);
    }

    @Override
    public String getP7derAttrs(byte[] originalHash, String hashAlg, String signTime, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        return this.safeEng.getP7derAttrs(originalHash, hashAlg, signTime, rv);
    }
}

