/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.security;

import cn.trust.sign.client.exceptions.SVSConnectException;
import cn.trust.sign.client.security.SignServiceImpl;
import cn.trust.sign.client.security.SuperEngine;
import cn.trust.sign.model.TrustSignInfo;
import com.dovtrust.client.config.PropertiesConfig;
import com.dovtrust.client.exceptions.InitException;
import com.dovtrust.client.exceptions.ParameterInvalidException;
import com.dovtrust.client.exceptions.ParameterOutRangeException;
import com.dovtrust.client.framework.transport.Transport;
import com.dovtrust.client.utils.GetPathUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.json.simple.parser.ParseException;

public abstract class SignService
implements SuperEngine {
    private static boolean isSuccess = false;
    private static SignServiceImpl safeEng = null;

    private static void loadConfig() throws InitException {
        if (!isSuccess) {
            isSuccess = PropertiesConfig.loadConfig();
            if (!isSuccess) {
                System.out.println("Configuration file read error, please check the file path or file's attribute!!!");
                throw new InitException("Configuration file read error, please check the file path or file's attribute!!!");
            }
            System.out.println("\u51c6\u5907\u521d\u59cb\u5316\u8fde\u63a5Transport.initConnectionPool");
            isSuccess = Transport.initConnectionPool();
        }
    }

    public static synchronized void configPath(String rootPath) throws InitException {
        if (rootPath != null && !"".equals(rootPath)) {
            File tempFile;
            if (rootPath.length() - rootPath.lastIndexOf(File.separator) == 1) {
                rootPath = rootPath.substring(0, rootPath.lastIndexOf(File.separator));
            }
            if (!(tempFile = new File(rootPath)).exists()) {
                throw new InitException("SignService initialization error," + tempFile.getPath() + " is not exits !" + 700026);
            }
        } else {
            throw new InitException("SignService configPath paramPath is null!700026");
        }
        GetPathUtil.setProfileDir((String)rootPath);
    }

    @Deprecated
    public static synchronized void setProfilePath(String rootPath) throws InitException {
        if (rootPath != null && !"".equals(rootPath)) {
            File tempFile;
            if (rootPath.length() - rootPath.lastIndexOf(File.separator) == 1) {
                rootPath = rootPath.substring(0, rootPath.lastIndexOf(File.separator));
            }
            if (!(tempFile = new File(rootPath)).exists()) {
                throw new InitException("SignService initialization error," + tempFile.getPath() + " is not exits !" + 700026);
            }
            tempFile = new File(String.valueOf(rootPath) + File.separator + "logs" + File.separator);
            if (!tempFile.exists()) {
                tempFile.mkdir();
            }
        } else {
            throw new InitException("SignService initialization error,path is null!700026");
        }
        GetPathUtil.setProfileDir((String)rootPath);
    }

    public static SignService getInstance() throws InitException {
        SignService.loadConfig();
        if (GetPathUtil.getProfileDir() == null || "".equals(GetPathUtil.getProfileDir())) {
            throw new InitException("Please init SignService configPath first!");
        }
        Class<SignService> clazz = SignService.class;
        synchronized (SignService.class) {
            if (isSuccess) {
                if (safeEng == null) {
                    safeEng = new SignServiceImpl();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return safeEng;
            }
            throw new InitException("SignService initialization error !");
        }
    }

    public static SignService getInstance(String appName) throws InitException {
        if (listApp.size() == 0) {
            SignService.loadConfig();
        }
        if (GetPathUtil.getProfileDir() == null || "".equals(GetPathUtil.getProfileDir())) {
            throw new InitException("Please init SignService configPath first!");
        }
        if (listApp.containsKey(appName)) {
            return (SignService)listApp.get(appName);
        }
        Class<SignService> clazz = SignService.class;
        synchronized (SignService.class) {
            if (listApp.containsKey(appName)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (SignService)listApp.get(appName);
            }
            if (isSuccess) {
                SignServiceImpl safeEng = new SignServiceImpl(appName);
                listApp.put(appName, safeEng);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return safeEng;
            }
            throw new InitException("SignService initialization error !");
        }
    }

    public abstract boolean finalizeEngine();

    public abstract String hashSign(String var1, String var2, int[] var3) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException;

    public abstract String unitSignByKW(String var1) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException, Exception;

    public abstract byte[] unitSignByKW(byte[] var1, byte[] var2, String var3, int[] var4) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException, UnsupportedEncodingException;

    public abstract String unitSignByXYZ(String var1) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException, Exception;

    public abstract byte[] unitSignByXYZ(byte[] var1, byte[] var2, String var3, int[] var4) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException, UnsupportedEncodingException;

    public abstract byte[] unitSignByRule(String var1, byte[] var2, String var3, int[] var4) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException;

    public abstract byte[] unitSignByRule(String var1, byte[] var2, String var3, String var4, int[] var5) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, Exception;

    public abstract String textToImg(String var1) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException;

    public abstract int pdfSignLTPEvent(String var1, String var2) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException;

    public abstract byte[] verifyPDF(byte[] var1, int[] var2) throws SVSConnectException, ParameterInvalidException, ParseException, ParameterOutRangeException, UnsupportedEncodingException;

    @Deprecated
    public abstract String verifyPDF(String var1, int[] var2) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException;

    public abstract List<byte[]> signPDF(TrustSignInfo var1, int[] var2) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException;

    public abstract String signData(byte[] var1, int var2, int var3, int var4, int[] var5) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract String signDataHash(byte[] var1, int[] var2) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract String signDataHashP7(byte[] var1, int[] var2) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract String signDataHashP1(String var1, String var2, int[] var3) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract String signDataHashP7(String var1, String var2, int[] var3) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract String signDataHashP7WithUserInfo(String var1, String var2, int[] var3) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException;

    public abstract byte[] verifySign(byte[] var1, String var2, int var3, int[] var4) throws SVSConnectException, UnsupportedEncodingException, ParameterInvalidException;

    public abstract List<String> genP10(String var1, int var2, String var3, String var4, int[] var5) throws ParameterInvalidException, SVSConnectException, Exception;

    public abstract String genCertByP10(String var1, String var2, String var3, String var4, int[] var5) throws ParameterInvalidException, SVSConnectException, UnsupportedEncodingException, IOException;

    public abstract byte[] signPdf(byte[] var1, byte[] var2, String var3, String var4, int[] var5) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, UnsupportedEncodingException;

    public abstract byte[] signPdfXYZByPrikey(byte[] var1, byte[] var2, String var3, String var4, int[] var5) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, UnsupportedEncodingException;

    public abstract String signDataByPrikey(String var1, String var2, int var3, int var4, int var5, int[] var6) throws UnsupportedEncodingException, ParameterInvalidException, ParseException, SVSConnectException;

    public abstract byte[] signPdfWithAnnotation(byte[] var1, byte[] var2, String var3, String var4, int[] var5) throws ParameterInvalidException, ParameterOutRangeException, ParseException, SVSConnectException, UnsupportedEncodingException;

    public abstract String simpleSignDataByPrikey(String var1, String var2, int[] var3) throws UnsupportedEncodingException, ParameterInvalidException, ParseException, SVSConnectException;

    public abstract byte[] htmlToPdf(byte[] var1, int[] var2) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException;

    public abstract byte[] wordToPdf(byte[] var1, int[] var2) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException;

    public abstract byte[] pdfToImage(byte[] var1, int[] var2) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException;

    public abstract String packSignData(String var1, String var2, List<String> var3) throws ParameterInvalidException, ParseException, IOException;

    public abstract String saveEvidence(byte[] var1, int[] var2) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, Exception;

    public abstract String queryEvidence(String var1, int[] var2) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException;

    public abstract String updatePrikeyByPwd(String var1, String var2, String var3, int[] var4) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException;

    public abstract String getSignOriginal(byte[] var1, byte[] var2, String var3, int[] var4) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException;

    public abstract byte[] mergeP1SignValueToPdf(String var1, byte[] var2, int[] var3, byte[] var4, String var5, int[] var6) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException;

    public abstract String getP7derAttrs(byte[] var1, String var2, String var3, int[] var4) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException;
}

