/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.security;

import cn.trust.sign.client.constants.PDFConstant;
import cn.trust.sign.client.exceptions.SVSConnectException;
import cn.trust.sign.client.security.SuperEngine;
import cn.trust.sign.client.serializer.AssocArray;
import cn.trust.sign.client.serializer.PHPSerializer;
import cn.trust.sign.client.utils.EncUtils;
import cn.trust.sign.client.utils.FastBase64;
import cn.trust.sign.client.utils.FileUtils;
import cn.trust.sign.client.utils.JsonUtils;
import cn.trust.sign.client.utils.PackageUtils;
import cn.trust.sign.client.utils.SaveDataToListUtil;
import cn.trust.sign.model.Digest;
import cn.trust.sign.model.DocumentType;
import cn.trust.sign.model.GenTrust;
import cn.trust.sign.model.RuleBean;
import cn.trust.sign.model.SendMessageBean;
import cn.trust.sign.model.TrustSignInfo;
import com.dovtrust.client.exceptions.ParameterInvalidException;
import com.dovtrust.client.exceptions.ParameterOutRangeException;
import com.dovtrust.client.framework.transport.Transport;
import com.dovtrust.client.log.LoggerUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.parser.ParseException;

public class SecurityEngine
implements SuperEngine {
    String errorMsg = "";
    private String appName = "";

    public SecurityEngine() {
    }

    public SecurityEngine(String appName) {
        this.appName = appName;
    }

    public boolean finalizeEngine() {
        boolean isSuccess = Transport.releaseConnectionPool();
        return isSuccess;
    }

    public int pdfSignLTPEvent(String eventContent, String eventType) throws ParameterInvalidException, SVSConnectException, UnsupportedEncodingException {
        if (eventContent == null || eventContent.length() == 0 || eventType == null || eventType.length() == 0) {
            LoggerUtil.client_error((String)"eventContent is null!700019");
            throw new ParameterInvalidException("eventContent is null!700019");
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(eventContent);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        int businessId = 3027;
        int[] rv = new int[2];
        new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        return rv[0];
    }

    public String verifyPDF(String inFileName, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        if (inFileName != null && inFileName.indexOf("/") > 0 && inFileName.indexOf(File.separator) < 0) {
            inFileName = inFileName.replace("/", File.separator);
        } else if (inFileName != null && inFileName.indexOf("\\") > 0 && inFileName.indexOf(File.separator) < 0) {
            inFileName = inFileName.replace("\\", File.separator);
        }
        FileUtils.checkPdfBytes(inFileName, ".pdf");
        byte[] param1 = FileUtils.readFile(inFileName);
        return FastBase64.encode(this.verifyPDF(param1, rv));
    }

    public String hashSign(String hash, String base64Cert, int[] rv) throws SVSConnectException, UnsupportedEncodingException {
        String string = "\u8fd9\u662f\u6d4b\u8bd5\u6570\u636e!!!!";
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(string);
        int businessId = 3035;
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        System.out.println(new String(result, "UTF-8"));
        return null;
    }

    public byte[] signPDFWithUnit(String ruleNo, byte[] PDFBytes, String snapshotJson, int[] rv) throws SVSConnectException, ParameterInvalidException, ParameterOutRangeException, UnsupportedEncodingException {
        String extInfo = "";
        LoggerUtil.client_debug((String)("signPDFWithUnit params is : ruleNo = " + ruleNo + ",extInfo = " + extInfo));
        FileUtils.checkTemplate(ruleNo);
        FileUtils.checkPdfBytes(PDFBytes, ".pdf");
        FileUtils.checkExtInfoLength(extInfo);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(ruleNo);
        saveDataToListUtil.setParamLengthAndByteByObject(PDFBytes);
        saveDataToListUtil.setParamLengthAndByteByObject("test.pdf");
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        if (extInfo == null || extInfo.equals("")) {
            extInfo = "";
        }
        if (snapshotJson == null || snapshotJson.equals("")) {
            snapshotJson = "";
        }
        saveDataToListUtil.setParamLengthAndByteByObject(extInfo);
        saveDataToListUtil.setParamLengthAndByteByObject(snapshotJson);
        int businessId = 3025;
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(PDFBytes, result) : result;
        result = null;
        saveDataToListUtil = null;
        paramList = null;
        return outputFile;
    }

    public byte[] signPDFWithUnit(String ruleNo, byte[] pdfBytes, String base64Cert, String snapshotJson, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, Exception {
        String extInfo = "";
        LoggerUtil.client_debug((String)("signPDFWithUnit params is : ruleNo = " + ruleNo + ",extInfo = " + extInfo));
        FileUtils.checkpublicKey(base64Cert);
        FileUtils.checkTemplate(ruleNo);
        FileUtils.checkPdfBytes(pdfBytes, ".pdf");
        FileUtils.checkExtInfoLength(extInfo);
        if (extInfo == null || extInfo.equals("")) {
            extInfo = "";
        }
        GenTrust genTrust = new GenTrust();
        genTrust.setVersion("1.0");
        byte[] key = FastBase64.decode(EncUtils.genRandomNum(24));
        PublicKey publicKey = EncUtils.getPublicKey(base64Cert);
        genTrust.setSessionKey(EncUtils.getEncKey(key, publicKey));
        RuleBean ruleBean = new RuleBean(ruleNo, extInfo, FastBase64.encode(pdfBytes));
        String ruleBeanStr = JsonUtils.objToJson(ruleBean);
        String encData = EncUtils.getEncData(ruleBeanStr, key);
        genTrust.setSignReq(encData);
        String str = EncUtils.crcDigestHexStr(encData.getBytes());
        Digest digest = new Digest();
        digest.setAlg("CRC32");
        digest.setValue(str);
        genTrust.setSignReqDig(digest);
        String encString = JsonUtils.objToJson(genTrust);
        ArrayList<byte[]> dsBy = new ArrayList<byte[]>();
        dsBy.add(encString.getBytes());
        TrustSignInfo trustSignInfo = new TrustSignInfo();
        trustSignInfo.setDataSource(dsBy);
        trustSignInfo.setExtNote(snapshotJson);
        byte[] trustSignInfos = this.serialize(trustSignInfo);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(trustSignInfos);
        saveDataToListUtil.setParamLengthAndByteByObject("test.pdf");
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        int businessId = 3033;
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, key, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(pdfBytes, result) : result;
        result = null;
        saveDataToListUtil = null;
        paramList = null;
        return outputFile;
    }

    public byte[] unitSignByXYZ(byte[] pdfBytes, byte[] imageBytes, String jsonBean, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        SaveDataToListUtil saveDataToListUtil;
        ArrayList<byte[]> paramList;
        block6: {
            LoggerUtil.client_debug((String)("unitSignByXYZ params is :" + jsonBean));
            String message = null;
            String extInfo = "";
            int signAlpha = 100;
            paramList = new ArrayList<byte[]>();
            saveDataToListUtil = new SaveDataToListUtil(paramList);
            try {
                FileUtils.checkPdfBytes(pdfBytes, ".pdf");
                FileUtils.fileExists(imageBytes, 20480L);
                FileUtils.checkXYZPara(this.appName, 3, signAlpha, JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "signPage")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosL")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosB")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosR")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosT")));
                extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "extInfo"));
                FileUtils.checkExtInfoLength(extInfo);
                saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
                saveDataToListUtil.setParamLengthAndByteByObject(pdfBytes);
                saveDataToListUtil.setParamLengthAndByteByObject("test.pdf");
                String localIP = FileUtils.getLocalIP();
                saveDataToListUtil.setParamLengthAndByteByObject(localIP);
                if (extInfo == null || extInfo.equals("")) {
                    extInfo = " ";
                }
                saveDataToListUtil.setParamLengthAndByteByObject(extInfo);
                saveDataToListUtil.setParamLengthAndByteByObject(imageBytes);
                saveDataToListUtil.setParamLengthAndByteByObject("");
                saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "visiable")));
                saveDataToListUtil.setParamLengthAndByteByObject(signAlpha);
                saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "signPage")));
                saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosL"))));
                saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosB"))));
                saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosR"))));
                saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosT"))));
                String snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "snapshotJson"));
                if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
                    saveDataToListUtil.setParamLengthAndByteByObject(snapshotJson);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                message = e.getMessage();
                if (message == null || "".equals(message)) break block6;
                int index = message.indexOf(":");
                if (index != -1) {
                    String error = message.substring(index + 1);
                    rv[0] = error != null && !"".equals(error) ? Integer.parseInt(error) : 700085;
                } else {
                    message = "parse message error code is error";
                    rv[0] = 700085;
                }
                this.errorMsg = "\u53c2\u6570\u975e\u6b63\u5e38\u53c2\u6570;      \u9519\u8bef\u7801\u4e3a:" + rv[0];
                LoggerUtil.client_error((String)this.errorMsg);
                throw new ParameterInvalidException(this.errorMsg);
            }
        }
        int businessId = 3026;
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(pdfBytes, result) : result;
        result = null;
        return outputFile;
    }

    public String unitSignEncByXYZ(String jsonBean) throws ParseException, ParameterInvalidException, ParameterOutRangeException, SVSConnectException, Exception {
        LoggerUtil.client_debug((String)("unitSignEncByXYZ params is :" + jsonBean));
        String extInfo = "";
        int signAlpha = 100;
        try {
            FileUtils.checkpublicKey(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "cert")));
            FileUtils.checkPdfBytes(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "pdf")), ".pdf");
            FileUtils.fileExists(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "imageContent")), 20480L);
            FileUtils.checkXYZPara(this.appName, 3, signAlpha, JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "signPage")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosL")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosB")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosR")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "signPosT")));
            extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "extInfo"));
            FileUtils.checkExtInfoLength(extInfo);
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        if (extInfo == null || extInfo.equals("")) {
            extInfo = " ";
        }
        byte[] key = FastBase64.decode(EncUtils.genRandomNum(24));
        String encData = JsonUtils.getEncData(jsonBean, key, JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "cert")));
        ArrayList<byte[]> dsBy = new ArrayList<byte[]>();
        dsBy.add(encData.getBytes());
        TrustSignInfo trustSignInfo = new TrustSignInfo();
        trustSignInfo.setDataSource(dsBy);
        byte[] encDateBytes = this.serialize(trustSignInfo);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(encDateBytes);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject("test.pdf");
        saveDataToListUtil.setParamLengthAndByteByObject("");
        int businessId = 3034;
        int[] rv = new int[2];
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, key, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "pdf")), result) : result;
        result = null;
        String dataValue = FastBase64.encode(outputFile);
        return JsonUtils.parametersToJson("version", "1.0", "code", String.valueOf(rv[0]), "data", dataValue);
    }

    public byte[] verifyPDF(byte[] inputFile, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        if (inputFile == null || inputFile.length == 0) {
            throw new ParameterInvalidException("\u9a8c\u8bc1PDF\u4e3a\u7a7a");
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(inputFile);
        String fileName = "verify_" + System.currentTimeMillis() + ".pdf";
        saveDataToListUtil.setParamLengthAndByteByObject(fileName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        int businessId = 3028;
        byte[] outputFile = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        return outputFile;
    }

    public byte[] verifySign(byte[] signValue, String originalData, int type, int[] rv) throws SVSConnectException, UnsupportedEncodingException, ParameterInvalidException {
        String signOriginal = null;
        try {
            signOriginal = JsonUtils.getStringValue(JsonUtils.getValue(new String(signValue), "originalData"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        FileUtils.checkSignData(signOriginal, originalData);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(signValue);
        saveDataToListUtil.setParamLengthAndByteByObject(type);
        saveDataToListUtil.setParamLengthAndByteByObject(originalData);
        int businessId = 3041;
        byte[] resultBytes = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        return resultBytes;
    }

    public String signEncWithKW(String jsonBean) throws ParameterInvalidException, ParseException, ParameterOutRangeException, SVSConnectException, Exception {
        LoggerUtil.client_debug((String)("signEncWithKW params is : " + jsonBean));
        int signAlpha = 100;
        boolean hasPos = true;
        int pos = 3;
        FileUtils.checkAppName(this.appName);
        try {
            if (JsonUtils.getValue(jsonBean, "pos") != null && !JsonUtils.getValue(jsonBean, "pos").equals("")) {
                pos = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "pos"));
            } else {
                hasPos = false;
            }
            FileUtils.checkpublicKey(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "cert")));
            FileUtils.checkKeyword(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "keyword")));
            FileUtils.checkPdfBytes(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "pdf")), ".pdf");
            FileUtils.fileExists(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "imageContent")), 20480L);
            FileUtils.checkKWXYPara(3, signAlpha, JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "kwIndex")), pos, hasPos, JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "offset")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "xoffset")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "yoffset")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "imageWidth")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "imageHeight")));
            FileUtils.checkExtInfoLength(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "extInfo")));
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        byte[] key = FastBase64.decode(EncUtils.genRandomNum(24));
        String encData = JsonUtils.getEncData(jsonBean, key, JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "cert")));
        ArrayList<byte[]> dsBy = new ArrayList<byte[]>();
        dsBy.add(encData.getBytes());
        TrustSignInfo trustSignInfo = new TrustSignInfo();
        trustSignInfo.setDataSource(dsBy);
        byte[] encDataByte = this.serialize(trustSignInfo);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(encDataByte);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        toList.setParamLengthAndByteByObject("test.pdf");
        toList.setParamLengthAndByteByObject("");
        int businessId = JsonUtils.getValue(jsonBean, "pos").equals("") || JsonUtils.getValue(jsonBean, "pos") == null ? 3037 : 3032;
        int[] rv = new int[2];
        byte[] result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, key, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? toList.mergeByteArray(JsonUtils.getByteValue(JsonUtils.getValue(jsonBean, "pdf")), result) : result;
        result = null;
        toList = null;
        paramList = null;
        String dataValue = FastBase64.encode(outputFile);
        return JsonUtils.parametersToJson("version", "1.0", "code", String.valueOf(rv[0]), "data", dataValue);
    }

    public byte[] signWithKW(byte[] pdfBytes, byte[] imageBytes, String jsonBean, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        int businessId;
        float imageHeight;
        float imageWidth;
        int yoffset;
        int xoffset;
        int offset;
        int pos;
        int kwIndex;
        int signAlpha;
        String snapshotJson;
        String extInfo;
        boolean hasPos;
        block17: {
            LoggerUtil.client_debug((String)("signWithKW params is : " + jsonBean));
            hasPos = true;
            extInfo = "";
            snapshotJson = "";
            signAlpha = 100;
            kwIndex = 1;
            pos = 3;
            offset = 0;
            xoffset = 0;
            yoffset = 0;
            imageWidth = 0.0f;
            imageHeight = 0.0f;
            FileUtils.checkAppName(this.appName);
            String message = null;
            try {
                snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "snapshotJson"));
                if (JsonUtils.getValue(jsonBean, "kwIndex") != null && !JsonUtils.getValue(jsonBean, "kwIndex").equals("")) {
                    kwIndex = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "kwIndex"));
                }
                if (JsonUtils.getValue(jsonBean, "pos") != null && !JsonUtils.getValue(jsonBean, "pos").equals("")) {
                    pos = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "pos"));
                } else {
                    hasPos = false;
                }
                if (JsonUtils.getValue(jsonBean, "offset") != null && !JsonUtils.getValue(jsonBean, "offset").equals("")) {
                    offset = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "offset"));
                }
                if (JsonUtils.getValue(jsonBean, "xoffset") != null && !JsonUtils.getValue(jsonBean, "xoffset").equals("")) {
                    xoffset = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "xoffset"));
                }
                if (JsonUtils.getValue(jsonBean, "yoffset") != null && !JsonUtils.getValue(jsonBean, "yoffset").equals("")) {
                    yoffset = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "yoffset"));
                }
                if (JsonUtils.getValue(jsonBean, "imageWidth") != null && !JsonUtils.getValue(jsonBean, "imageWidth").equals("")) {
                    imageWidth = JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "imageWidth"));
                }
                if (JsonUtils.getValue(jsonBean, "imageHeight") != null && !JsonUtils.getValue(jsonBean, "imageHeight").equals("")) {
                    imageHeight = JsonUtils.getFloatValue(JsonUtils.getValue(jsonBean, "imageHeight"));
                }
                if (kwIndex == 0) {
                    kwIndex = 1;
                }
                FileUtils.checkKeyword(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "keyword")));
                FileUtils.checkPdfBytes(pdfBytes, ".pdf");
                FileUtils.fileExists(imageBytes, 20480L);
                FileUtils.checkKWXYPara(3, signAlpha, kwIndex, pos, hasPos, offset, xoffset, yoffset, imageWidth, imageHeight);
                extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "extInfo"));
                FileUtils.checkExtInfoLength(extInfo);
            }
            catch (ParseException e) {
                e.printStackTrace();
                message = e.getMessage();
                if (message == null || "".equals(message)) break block17;
                int index = message.indexOf(":");
                if (index != -1) {
                    String error = message.substring(index + 1);
                    rv[0] = error != null && !"".equals(error) ? Integer.parseInt(error) : 700085;
                } else {
                    message = "parse message error code is error";
                    rv[0] = 700085;
                }
                this.errorMsg = "\u53c2\u6570\u975e\u6b63\u5e38\u53c2\u6570;      \u9519\u8bef\u7801\u4e3a:" + rv[0];
                LoggerUtil.client_error((String)this.errorMsg);
                throw new ParameterInvalidException(this.errorMsg);
            }
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "keyword")));
        saveDataToListUtil.setParamLengthAndByteByObject(pdfBytes);
        saveDataToListUtil.setParamLengthAndByteByObject("test.pdf");
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        if (extInfo == null || extInfo.equals("")) {
            extInfo = "";
        }
        saveDataToListUtil.setParamLengthAndByteByObject(extInfo);
        saveDataToListUtil.setParamLengthAndByteByObject(imageBytes);
        saveDataToListUtil.setParamLengthAndByteByObject("");
        saveDataToListUtil.setParamLengthAndByteByObject(3);
        saveDataToListUtil.setParamLengthAndByteByObject(signAlpha);
        saveDataToListUtil.setParamLengthAndByteByObject(kwIndex);
        if (!hasPos) {
            saveDataToListUtil.setParamLengthAndByteByObject(xoffset);
            saveDataToListUtil.setParamLengthAndByteByObject(yoffset);
            businessId = 3036;
        } else {
            saveDataToListUtil.setParamLengthAndByteByObject(pos);
            saveDataToListUtil.setParamLengthAndByteByObject(offset);
            businessId = 3029;
        }
        saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(imageWidth));
        saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(imageHeight));
        if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
            saveDataToListUtil.setParamLengthAndByteByObject(snapshotJson);
        }
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(pdfBytes, result) : result;
        result = null;
        saveDataToListUtil = null;
        paramList = null;
        return outputFile;
    }

    public String textToImg(String jsonBean) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        String resultImage;
        int[] rv;
        block9: {
            LoggerUtil.client_debug((String)("signPDFWithUnit params is : " + jsonBean));
            rv = new int[2];
            resultImage = null;
            String message = null;
            try {
                String typeValue = (String)JsonUtils.getValue(jsonBean, "type");
                if (typeValue == null || typeValue.trim().length() == 0) {
                    String errorMsg = "\u7b7e\u7ea6\u7801\u7c7b\u578b\u4e3a\ufffd?\u76ee\u524d\u652f\u6301 1 \ufffd?2 ;      \u9519\u8bef\u7801\u4e3a:700080";
                    LoggerUtil.client_error((String)errorMsg);
                    throw new ParameterInvalidException(errorMsg);
                }
                int type = JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "type"));
                FileUtils.checkType(type);
                FileUtils.checkImageType(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "imageType")));
                if (1 == type) {
                    FileUtils.checkUNameText(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "text")));
                    FileUtils.checkUNamePara(JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "fontSize")), JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "fontFamily")), JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "fontColor")), JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "isBold")));
                } else if (2 == type) {
                    FileUtils.checkSealText(JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "text")));
                    FileUtils.checkSealPara(JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "sealWidth")), JsonUtils.getStringValue(JsonUtils.getValue(jsonBean, "sealType")), JsonUtils.getIntValue(JsonUtils.getValue(jsonBean, "sealCenter")));
                    String sealEinNumber = (String)JsonUtils.getValue(jsonBean, "sealEinNumber");
                    if (sealEinNumber != null && !"".equals(sealEinNumber.trim())) {
                        FileUtils.cheakSealEinNumber(sealEinNumber);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                message = e.getMessage();
                if (message == null || "".equals(message)) break block9;
                int index = message.indexOf(":");
                if (index != -1) {
                    String error = message.substring(index + 1);
                    rv[0] = error != null && !"".equals(error) ? Integer.parseInt(error) : 700085;
                } else {
                    message = "parse message error code is error";
                    rv[0] = 700085;
                }
                this.errorMsg = "\u53c2\u6570\u975e\u6b63\u5e38\u53c2\u6570;      \u9519\u8bef\u7801\u4e3a:" + rv[0];
                LoggerUtil.client_error((String)this.errorMsg);
                throw new ParameterInvalidException(this.errorMsg);
            }
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(jsonBean);
        int businessId = 3038;
        byte[] imgInfo = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        resultImage = rv[0] == 0 ? JsonUtils.parametersToJson("version", "1.0", "code", String.valueOf(rv[0]), "data", new String(imgInfo)) : JsonUtils.parametersToJson("version", "1.0", "code", String.valueOf(rv[0]));
        return resultImage;
    }

    public String signData(byte[] signData, int plainData, int certContent, int tsCertContent, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        FileUtils.checkVerfySignPara(plainData, certContent, tsCertContent);
        try {
            FileUtils.checkDataPara(JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SessionKey")), JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SignReq")), JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SignReqDig")));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(signData);
        saveDataToListUtil.setParamLengthAndByteByObject(plainData);
        saveDataToListUtil.setParamLengthAndByteByObject(certContent);
        saveDataToListUtil.setParamLengthAndByteByObject(tsCertContent);
        int businessId = 3040;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataHash(byte[] signData, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        try {
            FileUtils.checkDataPara(JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SessionKey")), JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SignReq")), JsonUtils.getStringValue(JsonUtils.getValue(new String(signData), "SignReqDig")));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(signData);
        int businessId = 3039;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataHashP7(byte[] signData, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(signData);
        int businessId = 3060;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataHashP1(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        String originalData = null;
        String prikey = null;
        String pwd = null;
        try {
            originalData = JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData"));
            prikey = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey"));
            pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        FileUtils.checkHashSignData(originalData);
        FileUtils.checkPriKey(prikey);
        FileUtils.checkPwd(pwd);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(originalData);
        saveDataToListUtil.setParamLengthAndByteByObject(prikey);
        saveDataToListUtil.setParamLengthAndByteByObject(pwd);
        int businessId = 3062;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataHashP7(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        String originalData = null;
        String prikey = null;
        String cert = null;
        String pwd = null;
        try {
            originalData = JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData"));
            prikey = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey"));
            cert = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert"));
            pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        FileUtils.checkHashSignData(originalData);
        FileUtils.checkeUserInfo(prikey, cert, pwd);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(originalData);
        saveDataToListUtil.setParamLengthAndByteByObject(prikey);
        saveDataToListUtil.setParamLengthAndByteByObject(pwd);
        saveDataToListUtil.setParamLengthAndByteByObject(cert);
        int businessId = 3061;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataHashP7WithUserInfo(String signInfoJson, String jsonUserInfo, int[] rv) throws SVSConnectException, ParameterInvalidException, ParseException, UnsupportedEncodingException {
        String originalData = null;
        String userName = null;
        String idNumber = null;
        String channelId = null;
        try {
            originalData = JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData"));
            userName = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "userName"));
            idNumber = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "idNumber"));
            channelId = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "channelId"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        FileUtils.checkSignDataHashP7WithUserInfoParams(originalData, userName, idNumber, channelId);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(originalData);
        saveDataToListUtil.setParamLengthAndByteByObject(userName);
        saveDataToListUtil.setParamLengthAndByteByObject(idNumber);
        saveDataToListUtil.setParamLengthAndByteByObject(channelId);
        int businessId = 3063;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public String signDataByPrikey(String signInfoJson, String jsonUserInfo, int plainData, int certContent, int tsCertContent, int[] rv) throws ParameterInvalidException, ParseException, UnsupportedEncodingException, SVSConnectException {
        block6: {
            String message = null;
            try {
                FileUtils.checkVerfySignPara(plainData, certContent, tsCertContent);
                FileUtils.checkSignDataPara(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData")));
                FileUtils.checkeUserInfo(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey")), JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert")), JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd")));
            }
            catch (ParseException e) {
                e.printStackTrace();
                message = e.getMessage();
                if (message == null || "".equals(message)) break block6;
                int index = message.indexOf(":");
                if (index != -1) {
                    String error = message.substring(index + 1);
                    rv[0] = error != null && !"".equals(error) ? Integer.parseInt(error) : 700085;
                } else {
                    message = "parse message error code is error";
                    rv[0] = 700085;
                }
                this.errorMsg = "\u53c2\u6570\u975e\u6b63\u5e38\u53c2\u6570;      \u9519\u8bef\u7801\u4e3a:" + rv[0];
                LoggerUtil.client_error((String)this.errorMsg);
                throw new ParameterInvalidException(this.errorMsg);
            }
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData")));
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "image")));
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "fpImage")));
        saveDataToListUtil.setParamLengthAndByteByObject(plainData);
        saveDataToListUtil.setParamLengthAndByteByObject(certContent);
        saveDataToListUtil.setParamLengthAndByteByObject(tsCertContent);
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey")));
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd")));
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert")));
        String snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "snapshotJson"));
        if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
            saveDataToListUtil.setParamLengthAndByteByObject(snapshotJson);
        }
        int businessId = 3048;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public byte[] signPdfWithAnnotation(byte[] pdfBytes, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, ParseException, NumberFormatException, SVSConnectException, UnsupportedEncodingException {
        byte[] result = null;
        try {
            FileUtils.checkKeyword(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            FileUtils.checkPdfBytes(pdfBytes, ".pdf");
            FileUtils.fileExists(imageBytes, 81920L);
            FileUtils.checkSignatureAnnotationParams(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "signatureAnnotation")), JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "signatureNumber")), JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "annotationPage")));
            boolean hasPos = true;
            int kwIndex = 1;
            int pos = 3;
            int startPageNo = 1;
            float offset = 0.0f;
            float xoffset = 0.0f;
            float yoffset = 0.0f;
            float imageWidth = 0.0f;
            float imageHeight = 0.0f;
            String snapshotJson = "";
            String extInfo = "";
            if (JsonUtils.getValue(jsonUserInfo, "prikey") == null || JsonUtils.getValue(jsonUserInfo, "prikey").equals("") || JsonUtils.getValue(jsonUserInfo, "prikey").equals("null")) {
                this.errorMsg = "\u79c1\u94a5\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700060";
                LoggerUtil.client_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            if (JsonUtils.getValue(jsonUserInfo, "cert") == null || JsonUtils.getValue(jsonUserInfo, "cert").equals("") || JsonUtils.getValue(jsonUserInfo, "cert").equals("null")) {
                this.errorMsg = "\u8bc1\u4e66\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700020";
                LoggerUtil.client_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            if (JsonUtils.getValue(jsonSignInfo, "kwIndex") != null && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("null")) {
                kwIndex = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "kwIndex"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "pos") != null && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("null")) {
                pos = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "pos"));
            } else {
                hasPos = false;
            }
            if (JsonUtils.getValue(jsonSignInfo, "startPage") != null && !JsonUtils.getValue(jsonSignInfo, "startPage").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "startPage").toString().equals("null")) {
                startPageNo = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "startPage"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "offset") != null && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("null")) {
                offset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "offset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "xoffset") != null && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("null")) {
                xoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "xoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "yoffset") != null && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("null")) {
                yoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "yoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageWidth") != null && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("null")) {
                imageWidth = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageWidth"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageHeight") != null && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("null")) {
                imageHeight = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageHeight"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "extInfo") != null && !JsonUtils.getValue(jsonSignInfo, "extInfo").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "extInfo").toString().equals("null")) {
                extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "extInfo"));
            }
            FileUtils.checkKWXYPara(3, 100, kwIndex, pos, hasPos, offset, xoffset, yoffset, imageWidth, imageHeight);
            String pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
            FileUtils.checkPwd(pwd);
            ArrayList<byte[]> paramList = new ArrayList<byte[]>();
            SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
            toList.setParamLengthAndByteByObject(this.appName);
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey")));
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd")));
            toList.setParamLengthAndByteByObject(pdfBytes);
            toList.setParamLengthAndByteByObject(imageBytes);
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            toList.setParamLengthAndByteByObject(kwIndex);
            toList.setParamLengthAndByteByObject(pos);
            toList.setParamLengthAndByteByObject(startPageNo);
            toList.setParamLengthAndByteByObject(Float.valueOf(offset));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageWidth));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageHeight));
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert")));
            snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "snapshotJson"));
            if (snapshotJson != null && !snapshotJson.equals("null")) {
                toList.setParamLengthAndByteByObject(snapshotJson);
            } else {
                toList.setParamLengthAndByteByObject("");
            }
            toList.setParamLengthAndByteByObject(extInfo);
            String signatureAnnotation = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "signatureAnnotation"));
            if (signatureAnnotation != null) {
                toList.setParamLengthAndByteByObject(signatureAnnotation);
                String signatureNumber = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "signatureNumber"));
                if (!"".equals(signatureNumber) && signatureNumber != null) {
                    toList.setParamLengthAndByteByObject(signatureNumber);
                } else {
                    toList.setParamLengthAndByteByObject(1);
                }
                String annotationPage = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "annotationPage"));
                if (!"".equals(annotationPage) && annotationPage != null) {
                    toList.setParamLengthAndByteByObject(annotationPage);
                } else {
                    toList.setParamLengthAndByteByObject(1);
                }
            } else {
                toList.setParamLengthAndByteByObject("");
            }
            String localIP = FileUtils.getLocalIP();
            toList.setParamLengthAndByteByObject(localIP);
            int businessId = 3053;
            result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        }
        catch (Exception e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        return result;
    }

    public String simpleSignDataByPrikey(String signInfoJson, String jsonUserInfo, int[] rv) throws ParameterInvalidException, ParseException, UnsupportedEncodingException, SVSConnectException {
        String originalData = null;
        String prikey = null;
        String cert = null;
        String pwd = null;
        try {
            originalData = JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "originalData"));
            prikey = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey"));
            cert = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert"));
            pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        FileUtils.checkSignDataPara(originalData);
        FileUtils.checkeUserInfo(prikey, cert, pwd);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        String localIP = FileUtils.getLocalIP();
        saveDataToListUtil.setParamLengthAndByteByObject(localIP);
        saveDataToListUtil.setParamLengthAndByteByObject(originalData);
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "image")));
        saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(signInfoJson, "fpImage")));
        saveDataToListUtil.setParamLengthAndByteByObject(prikey);
        saveDataToListUtil.setParamLengthAndByteByObject(pwd);
        saveDataToListUtil.setParamLengthAndByteByObject(cert);
        int businessId = 3050;
        byte[] resultDatas = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        return new String(resultDatas);
    }

    public byte[] signPdfXYZByPrikey(byte[] pdfBytes, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, ParseException, UnsupportedEncodingException {
        LoggerUtil.dov_debug((String)("signPdfXYZByPrikey jsonUserInfo is :" + jsonUserInfo));
        LoggerUtil.dov_debug((String)("signPdfXYZByPrikey jsonSignInfo is :" + jsonSignInfo));
        String extInfo = "";
        int signAlpha = 100;
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil saveDataToListUtil = new SaveDataToListUtil(paramList);
        try {
            if (JsonUtils.getValue(jsonUserInfo, "prikey") == null || JsonUtils.getValue(jsonUserInfo, "prikey").equals("") || JsonUtils.getValue(jsonUserInfo, "prikey").equals("null")) {
                this.errorMsg = "\u79c1\u94a5\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700060";
                LoggerUtil.dov_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            if (JsonUtils.getValue(jsonUserInfo, "cert") == null || JsonUtils.getValue(jsonUserInfo, "cert").equals("") || JsonUtils.getValue(jsonUserInfo, "cert").equals("null")) {
                this.errorMsg = "\u8bc1\u4e66\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700020";
                LoggerUtil.dov_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            String pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
            FileUtils.checkPwd(pwd);
            FileUtils.checkPdfBytes(pdfBytes, ".pdf");
            FileUtils.fileExists(imageBytes, 20480L);
            FileUtils.checkXYZPara_NoAppName(3, signAlpha, JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "signPage")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosL")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosB")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosR")), JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosT")));
            extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "extInfo"));
            FileUtils.checkExtInfoLength(extInfo);
            saveDataToListUtil.setParamLengthAndByteByObject(this.appName);
            saveDataToListUtil.setParamLengthAndByteByObject(pdfBytes);
            saveDataToListUtil.setParamLengthAndByteByObject(imageBytes);
            saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert")));
            saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey")));
            saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd")));
            saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "visiable")));
            saveDataToListUtil.setParamLengthAndByteByObject(signAlpha);
            saveDataToListUtil.setParamLengthAndByteByObject(JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "signPage")));
            saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosL"))));
            saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosB"))));
            saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosR"))));
            saveDataToListUtil.setParamLengthAndByteByObject(Float.valueOf(JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "signPosT"))));
            String localIP = FileUtils.getLocalIP();
            saveDataToListUtil.setParamLengthAndByteByObject(localIP);
            if (extInfo == null || extInfo.equals("")) {
                extInfo = " ";
            }
            saveDataToListUtil.setParamLengthAndByteByObject(extInfo);
            String snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "snapshotJson"));
            if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
                saveDataToListUtil.setParamLengthAndByteByObject(snapshotJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.dov_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        int businessId = 3024;
        byte[] result = new SendMessageBean().sendMessage(businessId, saveDataToListUtil, paramList, this.appName, rv);
        byte[] outputFile = null;
        outputFile = result != null && result[0] != 37 ? saveDataToListUtil.mergeByteArray(pdfBytes, result) : result;
        result = null;
        return outputFile;
    }

    public List<byte[]> signPDFWithEnc(TrustSignInfo trustSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException {
        DocumentType docType;
        if (trustSignInfo == null) {
            rv[0] = 700008;
            LoggerUtil.client_error((String)("Parameter encData is null!!! errorCode : " + rv[0]));
            return null;
        }
        List<byte[]> lst = trustSignInfo.getDataSource();
        if (lst == null || lst.size() == 0) {
            rv[0] = 700008;
            LoggerUtil.client_error((String)("Parameter encData is null!!! errorCode : " + rv[0]));
            return null;
        }
        int j = 0;
        while (j < lst.size()) {
            byte[] encData = lst.get(j);
            if (new String(encData).trim().length() == 0) {
                rv[0] = 700008;
                LoggerUtil.client_error((String)("Parameter encData is null!!! errorCode : " + rv[0]));
                return null;
            }
            if (encData.length / 0x100000 > 10) {
                rv[0] = PDFConstant.PDF_TOO_BIG_ERROR_CODE;
                LoggerUtil.client_error((String)("Parameter encData is too big!!! errorCode : " + rv[0]));
                return null;
            }
            ++j;
        }
        byte[] pdfContent = trustSignInfo.getOriginalData();
        if (pdfContent != null && pdfContent.length > 0 && (docType = trustSignInfo.getDocType()) == null) {
            rv[0] = PDFConstant.SIGN_TYPE_ERROR_CODE;
            LoggerUtil.client_error((String)("Parameter docType is null!!! errorCode : " + rv[0]));
            return null;
        }
        if (trustSignInfo.getExtNote() != null && !"".equals(trustSignInfo.getExtNote()) && trustSignInfo.getExtNote().trim().length() != 0) {
            FileUtils.checkExtInfoLength(trustSignInfo.getExtNote());
        }
        if (trustSignInfo.getExtNote() == null || trustSignInfo.getExtNote().equals("")) {
            trustSignInfo.setExtNote(" ");
        }
        byte[] encDataByte = null;
        try {
            encDataByte = this.serialize(trustSignInfo);
        }
        catch (Exception e) {
            rv[0] = 700086;
            LoggerUtil.client_error((String)("serialize is error !!! errorCode : " + rv[0]));
            e.printStackTrace();
            return null;
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        try {
            toList.setParamLengthAndByteByObject(this.appName);
            toList.setParamLengthAndByteByObject(encDataByte);
            String localIP = FileUtils.getLocalIP();
            toList.setParamLengthAndByteByObject(localIP);
        }
        catch (UnsupportedEncodingException e) {
            rv[0] = 700087;
            LoggerUtil.client_error((String)("data conversion is error !!! errorCode : " + rv[0]));
            e.printStackTrace();
            return null;
        }
        int businessId = 3030;
        byte[] result = null;
        try {
            result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        }
        catch (SVSConnectException e) {
            LoggerUtil.client_error((String)("message:" + e.getMessage()));
            rv[0] = 700005;
            e.printStackTrace();
            return null;
        }
        if (rv[0] != 0) {
            LoggerUtil.client_error((String)("return ErrorCode:" + rv[0]));
            return null;
        }
        AssocArray lstBean = null;
        try {
            lstBean = (AssocArray)this.desPHPSerializer(result);
        }
        catch (Exception e) {
            rv[0] = 700086;
            LoggerUtil.client_error((String)("desPHPSerializer is error !!! errorCode : " + rv[0]));
            e.printStackTrace();
            return null;
        }
        ArrayList<byte[]> lstResult = new ArrayList<byte[]>();
        if (lstBean == null || lstBean.size() == 0) {
            LoggerUtil.client_error((String)("connect server fail!!! errorCode : " + PDFConstant.CONNECT_SERVER_FAIL_ERROR_CODE));
            rv[0] = PDFConstant.CONNECT_SERVER_FAIL_ERROR_CODE;
            return null;
        }
        int i = 0;
        while (i < lstBean.size()) {
            byte[] bTemp = (byte[])lstBean.get(i);
            lstResult.add(bTemp);
            ++i;
        }
        return lstResult;
    }

    public List<String> genP10(String certAlg, int pubKeyLength, String userName, String pwd, int[] rv) throws ParameterInvalidException, SVSConnectException, Exception {
        FileUtils.checkGenP10(certAlg, pubKeyLength, userName, pwd);
        if ("SM2".equals(certAlg.toUpperCase())) {
            certAlg = "ECC";
        }
        if ("RSA".equals(certAlg.toUpperCase())) {
            certAlg = "RSA";
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(certAlg);
        toList.setParamLengthAndByteByObject(pubKeyLength);
        toList.setParamLengthAndByteByObject(userName);
        toList.setParamLengthAndByteByObject(pwd);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3042;
        byte[] result = null;
        try {
            result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        }
        catch (SVSConnectException e) {
            LoggerUtil.client_error((String)("message:" + e.getMessage()));
            rv[0] = 700005;
            e.printStackTrace();
            return null;
        }
        ArrayList<String> lstResult = new ArrayList<String>();
        if (rv[0] == 0) {
            AssocArray lstBean = (AssocArray)this.desPHPSerializer(result);
            if (lstBean == null || lstBean.size() == 0) {
                LoggerUtil.client_error((String)("connect server fail!!! errorCode : " + PDFConstant.CONNECT_SERVER_FAIL_ERROR_CODE));
                rv[0] = PDFConstant.CONNECT_SERVER_FAIL_ERROR_CODE;
                return null;
            }
            int i = 0;
            while (i < lstBean.size()) {
                String bTemp = new String((byte[])lstBean.get(i));
                lstResult.add(bTemp);
                ++i;
            }
        }
        return lstResult;
    }

    public String genCertByP10(String certAlg, String p10, String appKey, String certOID, int[] rv) throws ParameterInvalidException, SVSConnectException, IOException {
        String result = null;
        String certOidJson = "";
        FileUtils.checkGenCert(certAlg, p10, appKey);
        if (certOID != null && !"".equals(certOID.trim())) {
            certOidJson = FileUtils.checkCertOID(certOID);
        }
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(certAlg);
        toList.setParamLengthAndByteByObject(p10);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        toList.setParamLengthAndByteByObject(appKey);
        toList.setParamLengthAndByteByObject(certOidJson);
        int businessId = 3043;
        byte[] resultObj = null;
        try {
            resultObj = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        }
        catch (SVSConnectException e) {
            LoggerUtil.client_error((String)("message:" + e.getMessage()));
            rv[0] = 700005;
            e.printStackTrace();
            return null;
        }
        if (String.valueOf(rv[0]).equals("0") && resultObj != null) {
            result = new String(resultObj);
        }
        return result;
    }

    public byte[] signPdf(byte[] pdfBytes, byte[] imageBytes, String jsonUserInfo, String jsonSignInfo, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, ParseException, NumberFormatException, SVSConnectException, UnsupportedEncodingException {
        byte[] result = null;
        try {
            FileUtils.checkKeyword(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            FileUtils.checkPdfBytes(pdfBytes, ".pdf");
            FileUtils.fileExists(imageBytes, 81920L);
            boolean hasPos = true;
            int kwIndex = 1;
            int pos = 3;
            float offset = 0.0f;
            float xoffset = 0.0f;
            float yoffset = 0.0f;
            float imageWidth = 0.0f;
            float imageHeight = 0.0f;
            String snapshotJson = "";
            String extInfo = "";
            if (JsonUtils.getValue(jsonUserInfo, "prikey") == null || JsonUtils.getValue(jsonUserInfo, "prikey").equals("") || JsonUtils.getValue(jsonUserInfo, "prikey").equals("null")) {
                this.errorMsg = "\u79c1\u94a5\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700060";
                LoggerUtil.client_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            if (JsonUtils.getValue(jsonUserInfo, "cert") == null || JsonUtils.getValue(jsonUserInfo, "cert").equals("") || JsonUtils.getValue(jsonUserInfo, "cert").equals("null")) {
                this.errorMsg = "\u8bc1\u4e66\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700020";
                LoggerUtil.client_error((String)this.errorMsg);
                throw new NullPointerException(this.errorMsg);
            }
            if (JsonUtils.getValue(jsonSignInfo, "kwIndex") != null && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("null")) {
                kwIndex = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "kwIndex"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "pos") != null && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("null")) {
                pos = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "pos"));
            } else {
                hasPos = false;
            }
            if (JsonUtils.getValue(jsonSignInfo, "offset") != null && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("null")) {
                offset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "offset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "xoffset") != null && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("null")) {
                xoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "xoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "yoffset") != null && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("null")) {
                yoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "yoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageWidth") != null && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("null")) {
                imageWidth = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageWidth"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageHeight") != null && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("null")) {
                imageHeight = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageHeight"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "extInfo") != null && !JsonUtils.getValue(jsonSignInfo, "extInfo").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "extInfo").toString().equals("null")) {
                extInfo = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "extInfo"));
            }
            FileUtils.checkKWXYPara(3, 100, kwIndex, pos, hasPos, offset, xoffset, yoffset, imageWidth, imageHeight);
            String pwd = JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd"));
            FileUtils.checkPwd(pwd);
            ArrayList<byte[]> paramList = new ArrayList<byte[]>();
            SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
            toList.setParamLengthAndByteByObject(this.appName);
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "prikey")));
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "pwd")));
            toList.setParamLengthAndByteByObject(pdfBytes);
            toList.setParamLengthAndByteByObject(imageBytes);
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            toList.setParamLengthAndByteByObject(kwIndex);
            toList.setParamLengthAndByteByObject(pos);
            toList.setParamLengthAndByteByObject(Float.valueOf(offset));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageWidth));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageHeight));
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonUserInfo, "cert")));
            snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "snapshotJson"));
            if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
                toList.setParamLengthAndByteByObject(snapshotJson);
            }
            toList.setParamLengthAndByteByObject(extInfo);
            String localIP = FileUtils.getLocalIP();
            toList.setParamLengthAndByteByObject(localIP);
            int businessId = 3044;
            try {
                result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
            }
            catch (SVSConnectException e) {
                LoggerUtil.client_error((String)("message:" + e.getMessage()));
                rv[0] = 700005;
                e.printStackTrace();
                return null;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        return result;
    }

    public byte[] htmlToPdf(byte[] htmlBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        byte[] result = null;
        FileUtils.checkHtmlBytes(htmlBytes);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(htmlBytes);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3045;
        result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        return result;
    }

    public byte[] wordToPdf(byte[] wordBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        byte[] result = null;
        FileUtils.checkHtmlBytes(wordBytes);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(wordBytes);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3054;
        result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        return result;
    }

    public byte[] pdfToImage(byte[] pdfBytes, int[] rv) throws ParameterInvalidException, ParameterOutRangeException, SVSConnectException, UnsupportedEncodingException {
        byte[] result = null;
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(pdfBytes);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3070;
        result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        return result;
    }

    public String packSignData(String originalData, String channel, List<String> UserSigns) throws ParameterInvalidException, ParseException, IOException {
        FileUtils.checkPackSignData(originalData, channel, UserSigns);
        String encData = PackageUtils.signDataPack(originalData, channel, UserSigns);
        return encData;
    }

    public String saveEvidence(byte[] inData, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, Exception {
        FileUtils.checkOriginal(inData);
        String tsRequest = "";
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(tsRequest);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3046;
        byte[] result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        if (rv[0] != 0) {
            return null;
        }
        return new String(result);
    }

    public String queryEvidence(String txId, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException {
        FileUtils.checkTxId(txId);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(txId);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3047;
        byte[] result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        if (rv[0] != 0) {
            return null;
        }
        return new String(result);
    }

    public String updatePrikeyByPwd(String oldPwd, String oldPrikey, String newPwd, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException {
        String result = null;
        FileUtils.checkPriKey(oldPrikey);
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(oldPwd);
        toList.setParamLengthAndByteByObject(oldPrikey);
        toList.setParamLengthAndByteByObject(newPwd);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3049;
        byte[] b = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        if (rv[0] == 0) {
            result = new String(b);
        }
        return result;
    }

    public String getSignOriginal(byte[] pdfBytes, byte[] imageBytes, String jsonSignInfo, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        String signOriginal = null;
        byte[] result = null;
        try {
            FileUtils.checkKeyword(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            FileUtils.checkPdfBytes(pdfBytes, ".pdf");
            FileUtils.fileExists(imageBytes, 81920L);
            boolean hasPos = true;
            int kwIndex = 1;
            int pos = 3;
            float offset = 0.0f;
            float xoffset = 0.0f;
            float yoffset = 0.0f;
            float imageWidth = 0.0f;
            float imageHeight = 0.0f;
            String snapshotJson = "";
            if (JsonUtils.getValue(jsonSignInfo, "kwIndex") != null && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "kwIndex").toString().equals("null")) {
                kwIndex = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "kwIndex"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "pos") != null && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "pos").toString().equals("null")) {
                pos = JsonUtils.getIntValue(JsonUtils.getValue(jsonSignInfo, "pos"));
            } else {
                hasPos = false;
            }
            if (JsonUtils.getValue(jsonSignInfo, "offset") != null && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "offset").toString().equals("null")) {
                offset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "offset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "xoffset") != null && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "xoffset").toString().equals("null")) {
                xoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "xoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "yoffset") != null && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "yoffset").toString().equals("null")) {
                yoffset = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "yoffset"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageWidth") != null && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageWidth").toString().equals("null")) {
                imageWidth = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageWidth"));
            }
            if (JsonUtils.getValue(jsonSignInfo, "imageHeight") != null && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("") && !JsonUtils.getValue(jsonSignInfo, "imageHeight").toString().equals("null")) {
                imageHeight = JsonUtils.getFloatValue(JsonUtils.getValue(jsonSignInfo, "imageHeight"));
            }
            FileUtils.checkKWXYPara(3, 100, kwIndex, pos, hasPos, offset, xoffset, yoffset, imageWidth, imageHeight);
            ArrayList<byte[]> paramList = new ArrayList<byte[]>();
            SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
            toList.setParamLengthAndByteByObject(this.appName);
            toList.setParamLengthAndByteByObject(pdfBytes);
            toList.setParamLengthAndByteByObject(imageBytes);
            toList.setParamLengthAndByteByObject(JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "keyword")));
            toList.setParamLengthAndByteByObject(kwIndex);
            toList.setParamLengthAndByteByObject(pos);
            toList.setParamLengthAndByteByObject(Float.valueOf(offset));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageWidth));
            toList.setParamLengthAndByteByObject(Float.valueOf(imageHeight));
            snapshotJson = JsonUtils.getStringValue(JsonUtils.getValue(jsonSignInfo, "snapshotJson"));
            if (!snapshotJson.equals("") && !snapshotJson.equals("null")) {
                toList.setParamLengthAndByteByObject(snapshotJson);
            }
            String localIP = FileUtils.getLocalIP();
            toList.setParamLengthAndByteByObject(localIP);
            int businessId = 3051;
            result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        }
        catch (ParseException e) {
            e.printStackTrace();
            rv[0] = 700070;
            this.errorMsg = "\u89e3\u6790\u53c2\u6570json\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700070";
            LoggerUtil.client_error((String)this.errorMsg);
            throw new ParameterInvalidException(this.errorMsg);
        }
        if (rv[0] == 0) {
            signOriginal = new String(result);
        }
        return signOriginal;
    }

    public byte[] mergeP1SignValueToPdf(String signOriginalBase64, byte[] p7derAttrs, int[] byteRange, byte[] p1SignValue, String signCert, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        byte[] result = null;
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(signOriginalBase64);
        toList.setParamLengthAndByteByObject(p7derAttrs);
        toList.setParamLengthAndByteByObject(byteRange);
        toList.setParamLengthAndByteByObject(p1SignValue);
        toList.setParamLengthAndByteByObject(signCert);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3052;
        result = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        return result;
    }

    public String getP7derAttrs(byte[] originalHash, String hashAlg, String signTime, int[] rv) throws UnsupportedEncodingException, SVSConnectException, ParameterInvalidException, ParameterOutRangeException, ParseException {
        String result = null;
        ArrayList<byte[]> paramList = new ArrayList<byte[]>();
        SaveDataToListUtil toList = new SaveDataToListUtil(paramList);
        toList.setParamLengthAndByteByObject(this.appName);
        toList.setParamLengthAndByteByObject(originalHash);
        toList.setParamLengthAndByteByObject(hashAlg);
        toList.setParamLengthAndByteByObject(signTime);
        String localIP = FileUtils.getLocalIP();
        toList.setParamLengthAndByteByObject(localIP);
        int businessId = 3055;
        byte[] p7derAttrs = new SendMessageBean().sendMessage(businessId, toList, paramList, this.appName, rv);
        if (p7derAttrs != null) {
            result = FastBase64.encode(p7derAttrs);
        }
        return result;
    }

    private byte[] serialize(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PHPSerializer phpSerializer = new PHPSerializer();
        return phpSerializer.serialize(obj);
    }

    private Object desPHPSerializer(byte[] by) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PHPSerializer formator1 = new PHPSerializer();
        return formator1.unserialize(by);
    }
}

