/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin.impl;

import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwUserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="FwUserServiceImpl")
public class FwUserServiceImpl
extends BaseServiceImpl<FwUser, Long>
implements IFwUserService {
    @Resource(name="FwUserDaoImpl")
    private IFwUserDao fwUserDao;

    @Resource(name="FwUserDaoImpl")
    public void setBaseDao(IFwUserDao fwUsernDao) {
        super.setBaseDao(fwUsernDao);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean loginNameExists(String loginName) {
        return this.fwUserDao.loginNameExists(loginName);
    }

    @Override
    @Transactional(readOnly=true)
    public FwUser findByLoginName(String loginName) {
        return this.fwUserDao.findByLoginName(loginName);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<FwRoles> findRoles(Long id) {
        FwUser fwUser = (FwUser)this.fwUserDao.find(id);
        if (fwUser != null) {
            return fwUser.getFwRoles();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    @Cacheable(value={"resouces"}, key="#root.targetClass")
    public Map<Long, FwUser> findAllUser() {
        HashMap<Long, FwUser> usersMap = new HashMap<Long, FwUser>();
        List fwUsers = super.findAll();
        for (FwUser fwUser : fwUsers) {
            if (!StatusEnum.Y.equals((Object)fwUser.getStatus())) continue;
            usersMap.put(fwUser.getId(), fwUser);
        }
        return usersMap;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isAuthenticated() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            return subject.isAuthenticated();
        }
        return false;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isSuperAdmin() {
        return this.getCurrent().isSuperAdminRole();
    }

    @Override
    @Transactional(readOnly=true)
    public FwUser getCurrent() {
        Principal principal;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (principal = (Principal)subject.getPrincipal()) != null) {
            return (FwUser)this.fwUserDao.find(principal.getId());
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Principal getCurrentPrincipal() {
        Principal principal;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (principal = (Principal)subject.getPrincipal()) != null) {
            return principal;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwUser> findOrgUsers(FwOrg fwOrg) {
        return this.fwUserDao.findOrgUsers(fwOrg);
    }

    @Override
    @CacheEvict(value={"resouces"}, key="#root.targetClass")
    public FwUser updateFwUser(FwUser fwUser) {
        return super.update(fwUser);
    }

    @Override
    @CacheEvict(value={"resouces"}, key="#root.targetClass")
    public void deleteFwUser(FwUser fwUser) {
        super.delete(fwUser);
    }

    @Override
    public Pagination<FwUser> findWaitMember(List<Long> memberIds, String queryName, Integer start, Integer limit) {
        return this.fwUserDao.findWaitMember(memberIds, queryName, start, limit);
    }

    @Override
    public void deleteUser(List<Long> userIds) {
        this.fwUserDao.deleteUser(userIds);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwUser> findUserAndOrg(String deptId, String userName, int page, int rows) {
        List<FwUser> fwUsers = this.fwUserDao.findUserAndOrg(deptId, userName, page, rows);
        return fwUsers;
    }

    @Override
    public Long getCount(String deptId, String userName) {
        Long count = this.fwUserDao.getCount(deptId, userName);
        return count;
    }

    @Override
    public Pagination<FwUser> findLikeUserName(String userName, Pageable pageable) {
        return this.fwUserDao.findLikeUserName(userName, pageable);
    }

    @Override
    public List<FwUser> findUserByRoleType(FwRoles.RoleEnum roleEnum) {
        return this.fwUserDao.findUserByRoleType(roleEnum);
    }

    @Override
    public List<FwUser> findUserByPermisson(String permissionCode) {
        HashSet<FwUser> fwUsers = new HashSet<FwUser>();
        fwUsers.addAll(this.fwUserDao.findUserByPermisson(permissionCode));
        fwUsers.addAll(this.fwUserDao.findUserByRolePermisson(permissionCode));
        fwUsers.addAll(this.fwUserDao.findUserByStationPermisson(permissionCode));
        return new ArrayList<FwUser>(fwUsers);
    }
}

